/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.hadoop.HadoopProcessors;
import com.hazelcast.jet.hadoop.impl.CsvInputFormat;
import com.hazelcast.jet.hadoop.impl.JobConfigurer;
import com.hazelcast.jet.hadoop.impl.JsonInputFormat;
import com.hazelcast.jet.hadoop.impl.WholeFileAsBytesInputFormat;
import com.hazelcast.jet.hadoop.impl.WholeFileAsTextInputFormat;
import com.hazelcast.jet.pipeline.file.AvroFileFormat;
import com.hazelcast.jet.pipeline.file.CsvFileFormat;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.JsonFileFormat;
import com.hazelcast.jet.pipeline.file.impl.FileSourceConfiguration;
import com.hazelcast.jet.pipeline.file.impl.FileSourceFactory;
import com.hazelcast.security.permission.ConnectorPermission;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.parquet.avro.AvroParquetInputFormat;

public class HadoopFileSourceFactory
implements FileSourceFactory {
    private final Map<String, JobConfigurer> configurers = new HashMap<String, JobConfigurer>();

    public HadoopFileSourceFactory() {
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new AvroFormatJobConfigurer());
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new CsvFormatJobConfigurer());
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new JsonFormatJobConfigurer());
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new LineTextJobConfigurer());
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new ParquetFormatJobConfigurer());
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new RawBytesFormatJobConfigurer());
        HadoopFileSourceFactory.addJobConfigurer(this.configurers, new TextJobConfigurer());
        ServiceLoader<JobConfigurer> loader = ServiceLoader.load(JobConfigurer.class);
        for (JobConfigurer jobConfigurer : loader) {
            HadoopFileSourceFactory.addJobConfigurer(this.configurers, jobConfigurer);
        }
    }

    private static void addJobConfigurer(Map<String, JobConfigurer> configurers, JobConfigurer configurer) {
        configurers.put(configurer.format(), configurer);
    }

    @Nonnull
    public <T> ProcessorMetaSupplier create(@Nonnull FileSourceConfiguration<T> fsc) {
        FileFormat fileFormat = Objects.requireNonNull(fsc.getFormat());
        JobConfigurer configurer = this.configurers.get(fileFormat.format());
        if (configurer == null) {
            throw new JetException("Could not find JobConfigurer for FileFormat: " + fileFormat.format() + ". Did you provide correct modules on classpath?");
        }
        return HadoopProcessors.readHadoopP((Permission)ConnectorPermission.file((String)fsc.getPath(), (String)"read"), HadoopFileSourceFactory.configureFn(fsc, configurer, fileFormat), configurer.projectionFn());
    }

    private static <T> ConsumerEx<Configuration> configureFn(final FileSourceConfiguration<T> fsc, final JobConfigurer configurer, final FileFormat<T> fileFormat) {
        return new ConsumerEx<Configuration>(){
            private static final long serialVersionUID = 1L;

            public void acceptEx(Configuration configuration) throws Exception {
                try {
                    configuration.setBoolean("mapreduce.input.fileinputformat.input.dir.nonrecursive.ignore.subdirs", true);
                    configuration.setBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
                    configuration.setBoolean("jet.source.sharedlocalfs", fsc.isSharedFileSystem());
                    configuration.setBoolean("jet.source.ignorefilenotfound", fsc.isIgnoreFileNotFound());
                    for (Map.Entry option : fsc.getOptions().entrySet()) {
                        configuration.set((String)option.getKey(), (String)option.getValue());
                    }
                    Job job = Job.getInstance(configuration);
                    Path inputPath = HadoopFileSourceFactory.getInputPath(fsc, configuration);
                    FileInputFormat.addInputPath(job, inputPath);
                    configurer.configure(job, fileFormat);
                    for (Map.Entry<String, String> entry : job.getConfiguration()) {
                        configuration.set(entry.getKey(), entry.getValue());
                    }
                }
                catch (IOException e) {
                    throw new JetException("Could not create a source", (Throwable)e);
                }
            }

            public List<Permission> permissions() {
                String keyFile = (String)fsc.getOptions().get("google.cloud.auth.service.account.json.keyfile");
                if (keyFile != null) {
                    return Arrays.asList(ConnectorPermission.file((String)keyFile, (String)"read"), ConnectorPermission.file((String)fsc.getPath(), (String)"read"));
                }
                return Collections.singletonList(ConnectorPermission.file((String)fsc.getPath(), (String)"read"));
            }
        };
    }

    @Nonnull
    private static <T> Path getInputPath(FileSourceConfiguration<T> fsc, Configuration configuration) throws IOException {
        Path path = new Path(fsc.getPath());
        try {
            FileSystem fs = path.getFileSystem(configuration);
            if (!fs.getFileStatus(path).isDirectory()) {
                throw new JetException("The given path (" + String.valueOf(path) + ") must point to a directory, not a file.");
            }
        }
        catch (FileNotFoundException e) {
            throw new JetException("The directory '" + String.valueOf(path) + "' does not exist.");
        }
        if (fsc.getGlob().equals("*")) {
            return new Path(fsc.getPath());
        }
        return new Path(fsc.getPath(), fsc.getGlob());
    }

    private static <T extends GenericContainer> T copy(T record) {
        if (record instanceof SpecificRecord) {
            SpecificRecord specificRecord = (SpecificRecord)record;
            return (T)SpecificData.get().deepCopy(specificRecord.getSchema(), specificRecord);
        }
        if (record instanceof GenericRecord) {
            GenericRecord genericRecord = (GenericRecord)record;
            return (T)GenericData.get().deepCopy(genericRecord.getSchema(), genericRecord);
        }
        throw new IllegalArgumentException("Unexpected record type: " + String.valueOf(record.getClass()));
    }

    private static class AvroFormatJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private AvroFormatJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            AvroFileFormat avroFileFormat = (AvroFileFormat)format;
            job.setInputFormatClass(AvroKeyInputFormat.class);
            Class reflectClass = avroFileFormat.reflectClass();
            if (reflectClass != null) {
                Schema schema = ReflectData.get().getSchema(reflectClass);
                AvroJob.setInputKeySchema(job, schema);
            } else {
                job.getConfiguration().setBoolean("jet.source.copyonread", Boolean.FALSE);
            }
        }

        public BiFunctionEx<AvroKey<?>, NullWritable, ?> projectionFn() {
            return (BiFunctionEx & Serializable)(k, v) -> {
                Object record = k.datum();
                return record instanceof GenericContainer ? HadoopFileSourceFactory.copy((GenericContainer)record) : record;
            };
        }

        @Override
        @Nonnull
        public String format() {
            return "avro";
        }
    }

    private static class CsvFormatJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private CsvFormatJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            CsvFileFormat csvFileFormat = (CsvFileFormat)format;
            job.setInputFormatClass(CsvInputFormat.class);
            job.getConfiguration().setBoolean("jet.source.copyonread", Boolean.FALSE);
            job.getConfiguration().set("csv.bean.class", csvFileFormat.clazz().getName());
            List fieldList = csvFileFormat.fieldNames();
            if (fieldList != null) {
                for (int i = 0; i < fieldList.size(); ++i) {
                    job.getConfiguration().set("csv.field.list." + i, (String)fieldList.get(i));
                }
            }
        }

        public BiFunctionEx<NullWritable, ?, ?> projectionFn() {
            return (BiFunctionEx & Serializable)(k, v) -> v;
        }

        @Override
        @Nonnull
        public String format() {
            return "csv";
        }
    }

    private static class JsonFormatJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private JsonFormatJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            JsonFileFormat jsonFileFormat = (JsonFileFormat)format;
            job.setInputFormatClass(JsonInputFormat.class);
            Configuration configuration = job.getConfiguration();
            configuration.setBoolean("jet.source.copyonread", Boolean.FALSE);
            configuration.setBoolean("json.multiline", jsonFileFormat.isMultiline());
            Class clazz = jsonFileFormat.clazz();
            if (clazz != null) {
                configuration.set("json.bean.class", clazz.getName());
            }
        }

        public BiFunctionEx<NullWritable, ?, ?> projectionFn() {
            return (BiFunctionEx & Serializable)(k, v) -> v;
        }

        @Override
        @Nonnull
        public String format() {
            return "json";
        }
    }

    private static class LineTextJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private LineTextJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            job.setInputFormatClass(TextInputFormat.class);
        }

        public BiFunctionEx<LongWritable, Text, String> projectionFn() {
            return (BiFunctionEx & Serializable)(k, v) -> v.toString();
        }

        @Override
        @Nonnull
        public String format() {
            return "lines";
        }
    }

    private static class ParquetFormatJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private ParquetFormatJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            job.setInputFormatClass(AvroParquetInputFormat.class);
            job.getConfiguration().setBoolean("jet.source.copyonread", Boolean.FALSE);
        }

        public BiFunctionEx<String, ?, ?> projectionFn() {
            return (BiFunctionEx & Serializable)(k, record) -> {
                if (record == null) {
                    return null;
                }
                if (record instanceof GenericContainer) {
                    return HadoopFileSourceFactory.copy((GenericContainer)record);
                }
                throw new IllegalArgumentException("Unexpected record type: " + String.valueOf(record.getClass()));
            };
        }

        @Override
        @Nonnull
        public String format() {
            return "parquet";
        }
    }

    private static class RawBytesFormatJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private RawBytesFormatJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            job.setInputFormatClass(WholeFileAsBytesInputFormat.class);
        }

        public BiFunctionEx<NullWritable, BytesWritable, byte[]> projectionFn() {
            return (BiFunctionEx & Serializable)(k, v) -> v.copyBytes();
        }

        @Override
        @Nonnull
        public String format() {
            return "bin";
        }
    }

    private static class TextJobConfigurer
    implements JobConfigurer {
        private static final long serialVersionUID = 1L;

        private TextJobConfigurer() {
        }

        @Override
        public <T> void configure(Job job, FileFormat<T> format) {
            job.setInputFormatClass(WholeFileAsTextInputFormat.class);
        }

        public BiFunctionEx<NullWritable, Text, String> projectionFn() {
            return (BiFunctionEx & Serializable)(k, v) -> v.toString();
        }

        @Override
        @Nonnull
        public String format() {
            return "txt";
        }
    }
}

