/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.avro;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.avro.AvroProcessors;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import java.io.File;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.avro.io.DatumReader;

public final class AvroSourceBuilder<D> {
    private static final String GLOB_WILDCARD = "*";
    private final String directory;
    private String glob = "*";
    private boolean sharedFileSystem;
    private final SupplierEx<? extends DatumReader<D>> datumReaderSupplier;

    AvroSourceBuilder(@Nonnull String directory, @Nonnull SupplierEx<? extends DatumReader<D>> datumReaderSupplier) {
        this.directory = directory;
        this.datumReaderSupplier = datumReaderSupplier;
    }

    public AvroSourceBuilder<D> glob(@Nonnull String glob) {
        this.glob = glob;
        return this;
    }

    public AvroSourceBuilder<D> sharedFileSystem(boolean sharedFileSystem) {
        this.sharedFileSystem = sharedFileSystem;
        return this;
    }

    public <T> BatchSource<T> build(@Nonnull BiFunctionEx<String, ? super D, T> mapOutputFn) {
        return Sources.batchFromProcessor((String)("avroFilesSource(" + String.valueOf(new File(this.directory, this.glob)) + ")"), (ProcessorMetaSupplier)AvroProcessors.readFilesP(this.directory, this.glob, this.sharedFileSystem, this.datumReaderSupplier, mapOutputFn));
    }

    public BatchSource<D> build() {
        return this.build((BiFunctionEx & Serializable)(filename, datum) -> datum);
    }
}

