/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.entryprocessor.DeleteSessionEntryProcessor;
import com.hazelcast.web.entryprocessor.GetAttributeEntryProcessor;
import com.hazelcast.web.entryprocessor.GetAttributeNamesEntryProcessor;
import com.hazelcast.web.entryprocessor.GetSessionStateEntryProcessor;
import com.hazelcast.web.entryprocessor.SessionUpdateEntryProcessor;

public class WebDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId((String)"hazelcast.serialization.ds.web", (int)-1000);
    public static final int SESSION_UPDATE = 1;
    public static final int SESSION_DELETE = 2;
    public static final int GET_ATTRIBUTE = 3;
    public static final int GET_ATTRIBUTE_NAMES = 4;
    public static final int GET_SESSION_STATE = 5;
    public static final int SESSION_STATE = 6;

    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            public IdentifiedDataSerializable create(int typeId) {
                return WebDataSerializerHook.this.getIdentifiedDataSerializable(typeId);
            }
        };
    }

    private IdentifiedDataSerializable getIdentifiedDataSerializable(int typeId) {
        return switch (typeId) {
            case 1 -> new SessionUpdateEntryProcessor();
            case 2 -> new DeleteSessionEntryProcessor();
            case 3 -> new GetAttributeEntryProcessor();
            case 4 -> new GetAttributeNamesEntryProcessor();
            case 5 -> new GetSessionStateEntryProcessor();
            case 6 -> new SessionState();
            default -> null;
        };
    }

    public int getFactoryId() {
        return F_ID;
    }
}

