/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.Serializer;

@SdkInternalApi
public class SerializerMarshaller {
    private static final MarshallingInfo<StructuredPojo> PARQUETSERDE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParquetSerDe").build();
    private static final MarshallingInfo<StructuredPojo> ORCSERDE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrcSerDe").build();
    private static final SerializerMarshaller instance = new SerializerMarshaller();

    public static SerializerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Serializer serializer, ProtocolMarshaller protocolMarshaller) {
        if (serializer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(serializer.getParquetSerDe(), PARQUETSERDE_BINDING);
            protocolMarshaller.marshall(serializer.getOrcSerDe(), ORCSERDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

