/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.MSKSourceDescription;
import java.util.Date;

@SdkInternalApi
public class MSKSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> MSKCLUSTERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MSKClusterARN").build();
    private static final MarshallingInfo<String> TOPICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopicName").build();
    private static final MarshallingInfo<StructuredPojo> AUTHENTICATIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationConfiguration").build();
    private static final MarshallingInfo<Date> DELIVERYSTARTTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStartTimestamp").timestampFormat("unixTimestamp").build();
    private static final MSKSourceDescriptionMarshaller instance = new MSKSourceDescriptionMarshaller();

    public static MSKSourceDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(MSKSourceDescription mSKSourceDescription, ProtocolMarshaller protocolMarshaller) {
        if (mSKSourceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(mSKSourceDescription.getMSKClusterARN(), MSKCLUSTERARN_BINDING);
            protocolMarshaller.marshall(mSKSourceDescription.getTopicName(), TOPICNAME_BINDING);
            protocolMarshaller.marshall(mSKSourceDescription.getAuthenticationConfiguration(), AUTHENTICATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(mSKSourceDescription.getDeliveryStartTimestamp(), DELIVERYSTARTTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

