/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model;

import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.OrcCompression;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.OrcFormatVersion;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.transform.OrcSerDeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OrcSerDe
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer stripeSizeBytes;
    private Integer blockSizeBytes;
    private Integer rowIndexStride;
    private Boolean enablePadding;
    private Double paddingTolerance;
    private String compression;
    private List<String> bloomFilterColumns;
    private Double bloomFilterFalsePositiveProbability;
    private Double dictionaryKeyThreshold;
    private String formatVersion;

    public void setStripeSizeBytes(Integer stripeSizeBytes) {
        this.stripeSizeBytes = stripeSizeBytes;
    }

    public Integer getStripeSizeBytes() {
        return this.stripeSizeBytes;
    }

    public OrcSerDe withStripeSizeBytes(Integer stripeSizeBytes) {
        this.setStripeSizeBytes(stripeSizeBytes);
        return this;
    }

    public void setBlockSizeBytes(Integer blockSizeBytes) {
        this.blockSizeBytes = blockSizeBytes;
    }

    public Integer getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    public OrcSerDe withBlockSizeBytes(Integer blockSizeBytes) {
        this.setBlockSizeBytes(blockSizeBytes);
        return this;
    }

    public void setRowIndexStride(Integer rowIndexStride) {
        this.rowIndexStride = rowIndexStride;
    }

    public Integer getRowIndexStride() {
        return this.rowIndexStride;
    }

    public OrcSerDe withRowIndexStride(Integer rowIndexStride) {
        this.setRowIndexStride(rowIndexStride);
        return this;
    }

    public void setEnablePadding(Boolean enablePadding) {
        this.enablePadding = enablePadding;
    }

    public Boolean getEnablePadding() {
        return this.enablePadding;
    }

    public OrcSerDe withEnablePadding(Boolean enablePadding) {
        this.setEnablePadding(enablePadding);
        return this;
    }

    public Boolean isEnablePadding() {
        return this.enablePadding;
    }

    public void setPaddingTolerance(Double paddingTolerance) {
        this.paddingTolerance = paddingTolerance;
    }

    public Double getPaddingTolerance() {
        return this.paddingTolerance;
    }

    public OrcSerDe withPaddingTolerance(Double paddingTolerance) {
        this.setPaddingTolerance(paddingTolerance);
        return this;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getCompression() {
        return this.compression;
    }

    public OrcSerDe withCompression(String compression) {
        this.setCompression(compression);
        return this;
    }

    public OrcSerDe withCompression(OrcCompression compression) {
        this.compression = compression.toString();
        return this;
    }

    public List<String> getBloomFilterColumns() {
        return this.bloomFilterColumns;
    }

    public void setBloomFilterColumns(Collection<String> bloomFilterColumns) {
        if (bloomFilterColumns == null) {
            this.bloomFilterColumns = null;
            return;
        }
        this.bloomFilterColumns = new ArrayList<String>(bloomFilterColumns);
    }

    public OrcSerDe withBloomFilterColumns(String ... bloomFilterColumns) {
        if (this.bloomFilterColumns == null) {
            this.setBloomFilterColumns(new ArrayList<String>(bloomFilterColumns.length));
        }
        for (String ele : bloomFilterColumns) {
            this.bloomFilterColumns.add(ele);
        }
        return this;
    }

    public OrcSerDe withBloomFilterColumns(Collection<String> bloomFilterColumns) {
        this.setBloomFilterColumns(bloomFilterColumns);
        return this;
    }

    public void setBloomFilterFalsePositiveProbability(Double bloomFilterFalsePositiveProbability) {
        this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
    }

    public Double getBloomFilterFalsePositiveProbability() {
        return this.bloomFilterFalsePositiveProbability;
    }

    public OrcSerDe withBloomFilterFalsePositiveProbability(Double bloomFilterFalsePositiveProbability) {
        this.setBloomFilterFalsePositiveProbability(bloomFilterFalsePositiveProbability);
        return this;
    }

    public void setDictionaryKeyThreshold(Double dictionaryKeyThreshold) {
        this.dictionaryKeyThreshold = dictionaryKeyThreshold;
    }

    public Double getDictionaryKeyThreshold() {
        return this.dictionaryKeyThreshold;
    }

    public OrcSerDe withDictionaryKeyThreshold(Double dictionaryKeyThreshold) {
        this.setDictionaryKeyThreshold(dictionaryKeyThreshold);
        return this;
    }

    public void setFormatVersion(String formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public OrcSerDe withFormatVersion(String formatVersion) {
        this.setFormatVersion(formatVersion);
        return this;
    }

    public OrcSerDe withFormatVersion(OrcFormatVersion formatVersion) {
        this.formatVersion = formatVersion.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStripeSizeBytes() != null) {
            sb.append("StripeSizeBytes: ").append(this.getStripeSizeBytes()).append(",");
        }
        if (this.getBlockSizeBytes() != null) {
            sb.append("BlockSizeBytes: ").append(this.getBlockSizeBytes()).append(",");
        }
        if (this.getRowIndexStride() != null) {
            sb.append("RowIndexStride: ").append(this.getRowIndexStride()).append(",");
        }
        if (this.getEnablePadding() != null) {
            sb.append("EnablePadding: ").append(this.getEnablePadding()).append(",");
        }
        if (this.getPaddingTolerance() != null) {
            sb.append("PaddingTolerance: ").append(this.getPaddingTolerance()).append(",");
        }
        if (this.getCompression() != null) {
            sb.append("Compression: ").append(this.getCompression()).append(",");
        }
        if (this.getBloomFilterColumns() != null) {
            sb.append("BloomFilterColumns: ").append(this.getBloomFilterColumns()).append(",");
        }
        if (this.getBloomFilterFalsePositiveProbability() != null) {
            sb.append("BloomFilterFalsePositiveProbability: ").append(this.getBloomFilterFalsePositiveProbability()).append(",");
        }
        if (this.getDictionaryKeyThreshold() != null) {
            sb.append("DictionaryKeyThreshold: ").append(this.getDictionaryKeyThreshold()).append(",");
        }
        if (this.getFormatVersion() != null) {
            sb.append("FormatVersion: ").append(this.getFormatVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrcSerDe)) {
            return false;
        }
        OrcSerDe other = (OrcSerDe)obj;
        if (other.getStripeSizeBytes() == null ^ this.getStripeSizeBytes() == null) {
            return false;
        }
        if (other.getStripeSizeBytes() != null && !other.getStripeSizeBytes().equals(this.getStripeSizeBytes())) {
            return false;
        }
        if (other.getBlockSizeBytes() == null ^ this.getBlockSizeBytes() == null) {
            return false;
        }
        if (other.getBlockSizeBytes() != null && !other.getBlockSizeBytes().equals(this.getBlockSizeBytes())) {
            return false;
        }
        if (other.getRowIndexStride() == null ^ this.getRowIndexStride() == null) {
            return false;
        }
        if (other.getRowIndexStride() != null && !other.getRowIndexStride().equals(this.getRowIndexStride())) {
            return false;
        }
        if (other.getEnablePadding() == null ^ this.getEnablePadding() == null) {
            return false;
        }
        if (other.getEnablePadding() != null && !other.getEnablePadding().equals(this.getEnablePadding())) {
            return false;
        }
        if (other.getPaddingTolerance() == null ^ this.getPaddingTolerance() == null) {
            return false;
        }
        if (other.getPaddingTolerance() != null && !other.getPaddingTolerance().equals(this.getPaddingTolerance())) {
            return false;
        }
        if (other.getCompression() == null ^ this.getCompression() == null) {
            return false;
        }
        if (other.getCompression() != null && !other.getCompression().equals(this.getCompression())) {
            return false;
        }
        if (other.getBloomFilterColumns() == null ^ this.getBloomFilterColumns() == null) {
            return false;
        }
        if (other.getBloomFilterColumns() != null && !other.getBloomFilterColumns().equals(this.getBloomFilterColumns())) {
            return false;
        }
        if (other.getBloomFilterFalsePositiveProbability() == null ^ this.getBloomFilterFalsePositiveProbability() == null) {
            return false;
        }
        if (other.getBloomFilterFalsePositiveProbability() != null && !other.getBloomFilterFalsePositiveProbability().equals(this.getBloomFilterFalsePositiveProbability())) {
            return false;
        }
        if (other.getDictionaryKeyThreshold() == null ^ this.getDictionaryKeyThreshold() == null) {
            return false;
        }
        if (other.getDictionaryKeyThreshold() != null && !other.getDictionaryKeyThreshold().equals(this.getDictionaryKeyThreshold())) {
            return false;
        }
        if (other.getFormatVersion() == null ^ this.getFormatVersion() == null) {
            return false;
        }
        return other.getFormatVersion() == null || other.getFormatVersion().equals(this.getFormatVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStripeSizeBytes() == null ? 0 : this.getStripeSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getBlockSizeBytes() == null ? 0 : this.getBlockSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getRowIndexStride() == null ? 0 : this.getRowIndexStride().hashCode());
        hashCode = 31 * hashCode + (this.getEnablePadding() == null ? 0 : this.getEnablePadding().hashCode());
        hashCode = 31 * hashCode + (this.getPaddingTolerance() == null ? 0 : this.getPaddingTolerance().hashCode());
        hashCode = 31 * hashCode + (this.getCompression() == null ? 0 : this.getCompression().hashCode());
        hashCode = 31 * hashCode + (this.getBloomFilterColumns() == null ? 0 : this.getBloomFilterColumns().hashCode());
        hashCode = 31 * hashCode + (this.getBloomFilterFalsePositiveProbability() == null ? 0 : this.getBloomFilterFalsePositiveProbability().hashCode());
        hashCode = 31 * hashCode + (this.getDictionaryKeyThreshold() == null ? 0 : this.getDictionaryKeyThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getFormatVersion() == null ? 0 : this.getFormatVersion().hashCode());
        return hashCode;
    }

    public OrcSerDe clone() {
        try {
            return (OrcSerDe)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrcSerDeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

