/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.services.kinesisanalytics.model.SourceSchema;
import java.util.List;

@SdkInternalApi
public class SourceSchemaMarshaller {
    private static final MarshallingInfo<StructuredPojo> RECORDFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormat").build();
    private static final MarshallingInfo<String> RECORDENCODING_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordEncoding").build();
    private static final MarshallingInfo<List> RECORDCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumns").build();
    private static final SourceSchemaMarshaller instance = new SourceSchemaMarshaller();

    public static SourceSchemaMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceSchema sourceSchema, ProtocolMarshaller protocolMarshaller) {
        if (sourceSchema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sourceSchema.getRecordFormat(), RECORDFORMAT_BINDING);
            protocolMarshaller.marshall(sourceSchema.getRecordEncoding(), RECORDENCODING_BINDING);
            protocolMarshaller.marshall(sourceSchema.getRecordColumns(), RECORDCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

