/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesis.waiters;

import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.waiters.DescribeStreamFunction;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.waiters.StreamExists;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.waiters.StreamNotExists;
import com.hazelcast.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import com.hazelcast.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.hazelcast.shaded.com.amazonaws.waiters.PollingStrategy;
import com.hazelcast.shaded.com.amazonaws.waiters.Waiter;
import com.hazelcast.shaded.com.amazonaws.waiters.WaiterBuilder;
import com.hazelcast.shaded.com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonKinesisWaiters {
    private final AmazonKinesis client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonKinesisWaiters");

    @SdkInternalApi
    public AmazonKinesisWaiters(AmazonKinesis client) {
        this.client = client;
    }

    public Waiter<DescribeStreamRequest> streamExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamExists.IsACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStreamRequest> streamNotExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

