/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesis.model.transform;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.ChildShard;
import java.util.List;

@SdkInternalApi
public class ChildShardMarshaller {
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").build();
    private static final MarshallingInfo<List> PARENTSHARDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentShards").build();
    private static final MarshallingInfo<StructuredPojo> HASHKEYRANGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashKeyRange").build();
    private static final ChildShardMarshaller instance = new ChildShardMarshaller();

    public static ChildShardMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChildShard childShard, ProtocolMarshaller protocolMarshaller) {
        if (childShard == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(childShard.getShardId(), SHARDID_BINDING);
            protocolMarshaller.marshall(childShard.getParentShards(), PARENTSHARDS_BINDING);
            protocolMarshaller.marshall(childShard.getHashKeyRange(), HASHKEYRANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

