/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesis.model.transform;

import com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.ChildShard;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.transform.HashKeyRangeJsonUnmarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.JsonUnmarshallerContext;
import com.hazelcast.shaded.com.amazonaws.transform.ListUnmarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.Unmarshaller;

public class ChildShardJsonUnmarshaller
implements Unmarshaller<ChildShard, JsonUnmarshallerContext> {
    private static ChildShardJsonUnmarshaller instance;

    @Override
    public ChildShard unmarshall(JsonUnmarshallerContext context) throws Exception {
        ChildShard childShard = new ChildShard();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ShardId", targetDepth)) {
                    context.nextToken();
                    childShard.setShardId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ParentShards", targetDepth)) {
                    context.nextToken();
                    childShard.setParentShards(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("HashKeyRange", targetDepth)) {
                    context.nextToken();
                    childShard.setHashKeyRange(HashKeyRangeJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return childShard;
    }

    public static ChildShardJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ChildShardJsonUnmarshaller();
        }
        return instance;
    }
}

