/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.kinesis.impl.AwsConfig;
import com.hazelcast.jet.kinesis.impl.source.InitialShardIterators;
import com.hazelcast.jet.kinesis.impl.source.KinesisSourcePMetaSupplier;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.retry.IntervalFunction;
import com.hazelcast.jet.retry.RetryStrategies;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Record;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Shard;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class KinesisSources {
    public static final String MILLIS_BEHIND_LATEST_METRIC = "millisBehindLatest";

    private KinesisSources() {
    }

    @Nonnull
    public static Builder<Map.Entry<String, byte[]>> kinesis(@Nonnull String stream) {
        return new Builder<Map.Entry<String, byte[]>>(Objects.requireNonNull(stream));
    }

    public static final class Builder<T> {
        private static final long INITIAL_RETRY_TIMEOUT_MS = 100L;
        private static final double EXPONENTIAL_BACKOFF_MULTIPLIER = 2.0;
        private static final long MAXIMUM_RETRY_TIMEOUT_MS = 3000L;
        private static final RetryStrategy DEFAULT_RETRY_STRATEGY = RetryStrategies.custom().intervalFunction(IntervalFunction.exponentialBackoffWithCap((long)100L, (double)2.0, (long)3000L)).build();
        @Nonnull
        private final String stream;
        @Nonnull
        private final AwsConfig awsConfig = new AwsConfig();
        @Nonnull
        private RetryStrategy retryStrategy = DEFAULT_RETRY_STRATEGY;
        @Nonnull
        private final InitialShardIterators initialShardIterators = new InitialShardIterators();
        @Nonnull
        private BiFunctionEx<? super Record, ? super Shard, ? extends T> projectionFn;

        private Builder(@Nonnull String stream) {
            this.stream = stream;
            this.projectionFn = new DefaultProjection<T>();
        }

        @Nonnull
        public Builder<T> withEndpoint(@Nullable String endpoint) {
            this.awsConfig.withEndpoint(endpoint);
            return this;
        }

        @Nonnull
        public Builder<T> withRegion(@Nullable String region) {
            this.awsConfig.withRegion(region);
            return this;
        }

        @Nonnull
        public Builder<T> withCredentials(@Nullable String accessKey, @Nullable String secretKey) {
            this.awsConfig.withCredentials(accessKey, secretKey);
            return this;
        }

        @Nonnull
        public Builder<T> withRetryStrategy(@Nonnull RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        @Nonnull
        public Builder<T> withInitialShardIteratorRule(@Nonnull String shardIdRegExp, @Nonnull String shardIteratorType, @Nullable String parameter) {
            this.initialShardIterators.add(shardIdRegExp, shardIteratorType, parameter);
            return this;
        }

        @Nonnull
        public <T_NEW> Builder<T_NEW> withProjectionFn(@Nonnull BiFunctionEx<Record, Shard, T_NEW> projectionFn) {
            this.projectionFn = projectionFn;
            return this;
        }

        @Nonnull
        public Builder<T> withExecutorServiceSupplier(@Nonnull SupplierEx<ExecutorService> executorSupplier) {
            this.awsConfig.withExecutorServiceSupplier(executorSupplier);
            return this;
        }

        @Nonnull
        public StreamSource<T> build() {
            String stream = this.stream;
            AwsConfig awsConfig = this.awsConfig;
            RetryStrategy retryStrategy = this.retryStrategy;
            InitialShardIterators initialShardIterators = this.initialShardIterators;
            BiFunctionEx projectionFn = this.projectionFn;
            return Sources.streamFromProcessorWithWatermarks((String)("Kinesis Source (" + stream + ")"), (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> new KinesisSourcePMetaSupplier(awsConfig, stream, retryStrategy, initialShardIterators, eventTimePolicy, projectionFn));
        }
    }

    private static class DefaultProjection<T>
    implements BiFunctionEx<Record, Shard, T> {
        private static final long serialVersionUID = 1L;

        private DefaultProjection() {
        }

        public T applyEx(Record record, Shard shard) {
            return (T)Util.entry((Object)record.getPartitionKey(), (Object)DefaultProjection.toArray(record));
        }

        private static byte[] toArray(Record record) {
            ByteBuffer buffer = record.getData();
            int position = buffer.position();
            int limit = buffer.limit();
            if (position == 0 && limit == buffer.capacity()) {
                return buffer.array();
            }
            return Arrays.copyOfRange(buffer.array(), position, limit);
        }
    }
}

