/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.net.InetAddress;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;

abstract class AbstractIpScriptFieldQuery
extends AbstractScriptFieldQuery<IpFieldScript> {
    AbstractIpScriptFieldQuery(Script script, IpFieldScript.LeafFactory leafFactory, String fieldName) {
        super(script, fieldName, leafFactory::newInstance);
    }

    @Override
    protected boolean matches(IpFieldScript scriptContext, int docId) {
        scriptContext.runForDoc(docId);
        return this.matches(scriptContext.values(), scriptContext.count());
    }

    @Override
    protected abstract boolean matches(BytesRef[] var1, int var2);

    protected static InetAddress decode(BytesRef ref) {
        return InetAddressPoint.decode(BytesReference.toBytes(new BytesArray(ref)));
    }
}

