/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.search.lookup.SourceLookup;

public class UnmappedFieldFetcher {
    private static final int AUTOMATON_MAX_DETERMINIZED_STATES = 100000;
    private final CharacterRunAutomaton unmappedFieldsFetchAutomaton;
    private final List<String> unmappedConcreteFields = new ArrayList<String>();
    private final Set<String> mappedFields;
    public static final UnmappedFieldFetcher EMPTY = new UnmappedFieldFetcher(Collections.emptySet(), Collections.emptyList());

    public UnmappedFieldFetcher(Set<String> mappedFields, List<String> unmappedFetchPatterns) {
        ArrayList<String> unmappedWildcardPatterns = new ArrayList<String>();
        for (String pattern : unmappedFetchPatterns) {
            if (Regex.isSimpleMatchPattern(pattern)) {
                unmappedWildcardPatterns.add(pattern);
                continue;
            }
            this.unmappedConcreteFields.add(pattern);
        }
        this.unmappedFieldsFetchAutomaton = UnmappedFieldFetcher.buildAutomaton(unmappedWildcardPatterns);
        this.mappedFields = mappedFields;
    }

    private static CharacterRunAutomaton buildAutomaton(List<String> patterns) {
        if (patterns.isEmpty()) {
            return null;
        }
        return new CharacterRunAutomaton(Regex.simpleMatchToAutomaton(patterns.toArray(new String[0])), 100000);
    }

    public void collectUnmapped(Map<String, DocumentField> documentFields, SourceLookup source) {
        if (this.unmappedFieldsFetchAutomaton == null && this.unmappedConcreteFields.isEmpty()) {
            return;
        }
        this.collectUnmapped(documentFields, source.source(), "", 0);
    }

    private void collectUnmapped(Map<String, DocumentField> documentFields, Map<String, Object> source, String parentPath, int lastState) {
        if (this.unmappedFieldsFetchAutomaton != null) {
            for (String key : source.keySet()) {
                int currentState;
                Object value = source.get(key);
                String currentPath = parentPath + key;
                if (this.mappedFields.contains(currentPath) || (currentState = UnmappedFieldFetcher.step(this.unmappedFieldsFetchAutomaton, key, lastState)) == -1) continue;
                if (value instanceof Map) {
                    Map objectMap = (Map)value;
                    this.collectUnmapped(documentFields, objectMap, currentPath + ".", UnmappedFieldFetcher.step(this.unmappedFieldsFetchAutomaton, ".", currentState));
                    continue;
                }
                if (value instanceof List) {
                    this.collectUnmappedList(documentFields, (List)value, currentPath, currentState);
                    continue;
                }
                if (!this.unmappedFieldsFetchAutomaton.isAccept(currentState) || value == null) continue;
                DocumentField currentEntry = documentFields.get(currentPath);
                if (currentEntry == null) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(value);
                    documentFields.put(currentPath, new DocumentField(currentPath, list));
                    continue;
                }
                currentEntry.getValues().add(value);
            }
        }
        if (this.unmappedConcreteFields != null) {
            for (String path : this.unmappedConcreteFields) {
                List<Object> values;
                if (this.mappedFields.contains(path) || (values = XContentMapValues.extractRawValues(path, source)).isEmpty()) continue;
                documentFields.put(path, new DocumentField(path, values));
            }
        }
    }

    private void collectUnmappedList(Map<String, DocumentField> documentFields, Iterable<?> iterable, String parentPath, int lastState) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : iterable) {
            if (value instanceof Map) {
                Map objectMap = (Map)value;
                this.collectUnmapped(documentFields, objectMap, parentPath + ".", UnmappedFieldFetcher.step(this.unmappedFieldsFetchAutomaton, ".", lastState));
                continue;
            }
            if (value instanceof List) {
                this.collectUnmappedList(documentFields, (List)value, parentPath, lastState);
                continue;
            }
            if (!this.unmappedFieldsFetchAutomaton.isAccept(lastState) || this.mappedFields.contains(parentPath)) continue;
            list.add(value);
        }
        if (!list.isEmpty()) {
            DocumentField currentEntry = documentFields.get(parentPath);
            if (currentEntry == null) {
                documentFields.put(parentPath, new DocumentField(parentPath, list));
            } else {
                currentEntry.getValues().addAll(list);
            }
        }
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, key.charAt(i));
        }
        return state;
    }
}

