/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GeoHashCellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoPoint valuesSource;
    private final int precision;
    private final GeoBoundingBox geoBoundingBox;

    public GeoHashCellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.geoBoundingBox = geoBoundingBox;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        return this.geoBoundingBox.isUnbounded() ? new UnboundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision) : new BoundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.geoBoundingBox);
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    private static class UnboundedCellValues
    extends CellValues {
        UnboundedCellValues(MultiGeoPointValues geoValues, int precision) {
            super(geoValues, precision);
        }

        @Override
        int advanceValue(GeoPoint target, int valuesIdx) {
            this.values[valuesIdx] = Geohash.longEncode(target.getLon(), target.getLat(), this.precision);
            return valuesIdx + 1;
        }
    }

    private static class BoundedCellValues
    extends CellValues {
        private final GeoBoundingBox bbox;
        private final boolean crossesDateline;

        BoundedCellValues(MultiGeoPointValues geoValues, int precision, GeoBoundingBox bbox) {
            super(geoValues, precision);
            this.bbox = bbox;
            this.crossesDateline = bbox.right() < bbox.left();
        }

        @Override
        int advanceValue(GeoPoint target, int valuesIdx) {
            String hash = Geohash.stringEncode(target.getLon(), target.getLat(), this.precision);
            if (this.validHash(hash)) {
                this.values[valuesIdx] = Geohash.longEncode(hash);
                return valuesIdx + 1;
            }
            return valuesIdx;
        }

        private boolean validHash(String hash) {
            Rectangle rectangle = Geohash.toBoundingBox(hash);
            if (this.bbox.top() > rectangle.getMinY() && this.bbox.bottom() < rectangle.getMaxY()) {
                if (this.crossesDateline) {
                    return this.bbox.left() < rectangle.getMaxX() || this.bbox.right() > rectangle.getMinX();
                }
                return this.bbox.left() < rectangle.getMaxX() && this.bbox.right() > rectangle.getMinX();
            }
            return false;
        }
    }
}

