/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import com.carrotsearch.hppc.IntHashSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.CorsHandler;
import org.elasticsearch.http.DefaultRestChannel;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpClientStatsTracker;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpReadTimeoutException;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.HttpTracer;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.HttpUtils;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public abstract class AbstractHttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(AbstractHttpServerTransport.class);
    private static final ActionListener<Void> NO_OP = ActionListener.wrap(() -> {});
    protected final Settings settings;
    public final HttpHandlingSettings handlingSettings;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ThreadPool threadPool;
    protected final HttpServerTransport.Dispatcher dispatcher;
    protected final CorsHandler corsHandler;
    private final NamedXContentRegistry xContentRegistry;
    protected final PortsRange port;
    protected final ByteSizeValue maxContentLength;
    private final String[] bindHosts;
    private final String[] publishHosts;
    private volatile BoundTransportAddress boundAddress;
    private final AtomicLong totalChannelsAccepted = new AtomicLong();
    private final Set<HttpChannel> httpChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PlainActionFuture<Void> allClientsClosedListener = PlainActionFuture.newFuture();
    private final RefCounted refCounted = AbstractRefCounted.of(() -> this.allClientsClosedListener.onResponse(null));
    private final Set<HttpServerChannel> httpServerChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final HttpClientStatsTracker httpClientStatsTracker;
    private final HttpTracer tracer;
    private volatile long slowLogThresholdMs;

    protected AbstractHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings) {
        this.settings = settings;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.dispatcher = dispatcher;
        this.handlingSettings = HttpHandlingSettings.fromSettings(settings);
        this.corsHandler = CorsHandler.fromSettings(settings);
        List<String> httpBindHost = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings);
        this.bindHosts = (httpBindHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : httpBindHost).toArray(Strings.EMPTY_ARRAY);
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        this.publishHosts = (httpPublishHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : httpPublishHost).toArray(Strings.EMPTY_ARRAY);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.tracer = new HttpTracer(settings, clusterSettings);
        clusterSettings.addSettingsUpdateConsumer(TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING, slowLogThreshold -> {
            this.slowLogThresholdMs = slowLogThreshold.getMillis();
        });
        this.slowLogThresholdMs = TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING.get(settings).getMillis();
        this.httpClientStatsTracker = new HttpClientStatsTracker(settings, clusterSettings, threadPool);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    @Override
    public HttpStats stats() {
        return new HttpStats(this.httpClientStatsTracker.getClientStats(), this.httpChannels.size(), this.totalChannelsAccepted.get());
    }

    protected void bindServer() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = AbstractHttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        this.boundAddress = new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), publishAddress);
        logger.info("{}", (Object)this.boundAddress);
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                Set<HttpServerChannel> set = this.httpServerChannels;
                synchronized (set) {
                    HttpServerChannel httpServerChannel = this.bind(new InetSocketAddress(hostAddress, portNumber));
                    this.httpServerChannels.add(httpServerChannel);
                    boundSocket.set(httpServerChannel.getLocalAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to " + NetworkAddress.format(hostAddress, this.port), (Throwable)lastException.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    protected abstract HttpServerChannel bind(InetSocketAddress var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Set<HttpServerChannel> set = this.httpServerChannels;
        synchronized (set) {
            if (!this.httpServerChannels.isEmpty()) {
                try {
                    CloseableChannel.closeChannels(new ArrayList<HttpServerChannel>(this.httpServerChannels), true);
                }
                catch (Exception e) {
                    logger.warn("exception while closing channels", (Throwable)e);
                }
                finally {
                    this.httpServerChannels.clear();
                }
            }
        }
        try {
            this.refCounted.decRef();
            CloseableChannel.closeChannels(new ArrayList<HttpChannel>(this.httpChannels), true);
        }
        catch (Exception e) {
            logger.warn("unexpected exception while closing http channels", (Throwable)e);
        }
        try {
            this.allClientsClosedListener.get();
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn("unexpected exception while waiting for http channels to close", (Throwable)e);
        }
        this.stopInternal();
    }

    @Override
    protected void doClose() {
    }

    protected abstract void stopInternal();

    static int resolvePublishPort(Settings settings, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (TransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (TransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ports.iterator().next().value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    public void onException(HttpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel(channel);
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e)) {
            logger.trace(() -> new ParameterizedMessage("close connection exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (NetworkExceptionHelper.isConnectException(e)) {
            logger.trace(() -> new ParameterizedMessage("connect exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof HttpReadTimeoutException) {
            logger.trace(() -> new ParameterizedMessage("http read timeout, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof CancelledKeyException) {
            logger.trace(() -> new ParameterizedMessage("cancelled key exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else {
            logger.warn(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        }
    }

    protected void onServerException(HttpServerChannel channel, Exception e) {
        logger.error((Message)new ParameterizedMessage("exception from http server channel caught on transport layer [channel={}]", (Object)channel), (Throwable)e);
    }

    protected void serverAcceptedChannel(HttpChannel httpChannel) {
        boolean addedOnThisCall = this.httpChannels.add(httpChannel);
        assert (addedOnThisCall) : "Channel should only be added to http channel set once";
        this.refCounted.incRef();
        httpChannel.addCloseListener(ActionListener.wrap(() -> {
            this.httpChannels.remove(httpChannel);
            this.refCounted.decRef();
        }));
        this.totalChannelsAccepted.incrementAndGet();
        this.httpClientStatsTracker.addClientStats(httpChannel);
        logger.trace(() -> new ParameterizedMessage("Http channel accepted: {}", (Object)httpChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        this.httpClientStatsTracker.updateClientStats(httpRequest, httpChannel);
        long startTime = this.threadPool.relativeTimeInMillis();
        try {
            this.handleIncomingRequest(httpRequest, httpChannel, httpRequest.getInboundException());
        }
        finally {
            long took = this.threadPool.relativeTimeInMillis() - startTime;
            long logThreshold = this.slowLogThresholdMs;
            if (logThreshold > 0L && took > logThreshold) {
                logger.warn("handling request [{}][{}][{}][{}] took [{}ms] which is above the warn threshold of [{}ms]", (Object)httpRequest.header("X-Opaque-Id"), (Object)httpRequest.method(), (Object)httpRequest.uri(), (Object)httpChannel, (Object)took, (Object)logThreshold);
            }
        }
    }

    void dispatchRequest(RestRequest restRequest, RestChannel channel, Throwable badRequestCause) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            if (badRequestCause != null) {
                this.dispatcher.dispatchBadRequest(channel, threadContext, badRequestCause);
            } else {
                this.populatePerRequestThreadContext0(restRequest, channel, threadContext);
                this.dispatcher.dispatchRequest(restRequest, channel, threadContext);
            }
        }
    }

    private void populatePerRequestThreadContext0(RestRequest restRequest, RestChannel channel, ThreadContext threadContext) {
        try {
            this.populatePerRequestThreadContext(restRequest, threadContext);
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error(() -> "failed to send failure response for uri [" + restRequest.uri() + "]", (Throwable)inner);
            }
        }
    }

    protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
    }

    private void handleIncomingRequest(HttpRequest httpRequest, HttpChannel httpChannel, Exception exception) {
        DefaultRestChannel innerChannel;
        RestRequest innerRestRequest;
        HttpResponse earlyResponse;
        if (exception == null && (earlyResponse = this.corsHandler.handleInbound(httpRequest)) != null) {
            httpChannel.sendResponse(earlyResponse, AbstractHttpServerTransport.earlyResponseListener(httpRequest, httpChannel));
            httpRequest.release();
            return;
        }
        Exception badRequestCause = exception;
        try {
            innerRestRequest = RestRequest.request(this.xContentRegistry, httpRequest, httpChannel);
        }
        catch (RestRequest.ContentTypeHeaderException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            innerRestRequest = this.requestWithoutContentTypeHeader(httpRequest, httpChannel, badRequestCause);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            innerRestRequest = RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequest, httpChannel);
        }
        RestRequest restRequest = innerRestRequest;
        HttpTracer trace = this.tracer.maybeTraceRequest(restRequest, exception);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try {
            innerChannel = new DefaultRestChannel(httpChannel, httpRequest, restRequest, this.bigArrays, this.handlingSettings, threadContext, this.corsHandler, trace);
        }
        catch (IllegalArgumentException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            RestRequest innerRequest = RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequest, httpChannel);
            innerChannel = new DefaultRestChannel(httpChannel, httpRequest, innerRequest, this.bigArrays, this.handlingSettings, threadContext, this.corsHandler, trace);
        }
        DefaultRestChannel channel = innerChannel;
        this.dispatchRequest(restRequest, channel, badRequestCause);
    }

    private RestRequest requestWithoutContentTypeHeader(HttpRequest httpRequest, HttpChannel httpChannel, Exception badRequestCause) {
        HttpRequest httpRequestWithoutContentType = httpRequest.removeHeader("Content-Type");
        try {
            return RestRequest.request(this.xContentRegistry, httpRequestWithoutContentType, httpChannel);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause.addSuppressed(e);
            return RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequestWithoutContentType, httpChannel);
        }
    }

    private static ActionListener<Void> earlyResponseListener(HttpRequest request, HttpChannel httpChannel) {
        if (HttpUtils.shouldCloseConnection(request)) {
            return ActionListener.wrap(() -> CloseableChannel.closeChannel(httpChannel));
        }
        return NO_OP;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }
}

