/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SingleNodeShutdownMetadata
extends AbstractDiffable<SingleNodeShutdownMetadata>
implements ToXContentObject,
Diffable<SingleNodeShutdownMetadata> {
    public static final Version REPLACE_SHUTDOWN_TYPE_ADDED_VERSION = Version.V_7_16_0;
    public static final ParseField NODE_ID_FIELD = new ParseField("node_id", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    public static final String STARTED_AT_READABLE_FIELD = "shutdown_started";
    public static final ParseField STARTED_AT_MILLIS_FIELD = new ParseField("shutdown_startedmillis", new String[0]);
    public static final ParseField ALLOCATION_DELAY_FIELD = new ParseField("allocation_delay", new String[0]);
    public static final ParseField NODE_SEEN_FIELD = new ParseField("node_seen", new String[0]);
    public static final ParseField TARGET_NODE_NAME_FIELD = new ParseField("target_node_name", new String[0]);
    public static final ConstructingObjectParser<SingleNodeShutdownMetadata, Void> PARSER = new ConstructingObjectParser("node_shutdown_info", a -> new SingleNodeShutdownMetadata((String)a[0], Type.valueOf((String)a[1]), (String)a[2], (Long)a[3], (Boolean)a[4], (TimeValue)a[5], (String)a[6]));
    public static final TimeValue DEFAULT_RESTART_SHARD_ALLOCATION_DELAY;
    private final String nodeId;
    private final Type type;
    private final String reason;
    private final long startedAtMillis;
    private final boolean nodeSeen;
    @Nullable
    private final TimeValue allocationDelay;
    @Nullable
    private final String targetNodeName;

    public static SingleNodeShutdownMetadata parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    private SingleNodeShutdownMetadata(String nodeId, Type type, String reason, long startedAtMillis, boolean nodeSeen, @Nullable TimeValue allocationDelay, @Nullable String targetNodeName) {
        this.nodeId = Objects.requireNonNull(nodeId, "node ID must not be null");
        this.type = Objects.requireNonNull(type, "shutdown type must not be null");
        this.reason = Objects.requireNonNull(reason, "shutdown reason must not be null");
        this.startedAtMillis = startedAtMillis;
        this.nodeSeen = nodeSeen;
        if (allocationDelay != null && !Type.RESTART.equals((Object)type)) {
            throw new IllegalArgumentException("shard allocation delay is only valid for RESTART-type shutdowns");
        }
        this.allocationDelay = allocationDelay;
        if (targetNodeName != null && type != Type.REPLACE) {
            throw new IllegalArgumentException(new ParameterizedMessage("target node name is only valid for REPLACE type shutdowns, but was given type [{}] and target node name [{}]", (Object)type, (Object)targetNodeName).getFormattedMessage());
        }
        if (!Strings.hasText(targetNodeName) && type == Type.REPLACE) {
            throw new IllegalArgumentException("target node name is required for REPLACE type shutdowns");
        }
        this.targetNodeName = targetNodeName;
    }

    public SingleNodeShutdownMetadata(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.type = in.readEnum(Type.class);
        this.reason = in.readString();
        this.startedAtMillis = in.readVLong();
        this.nodeSeen = in.readBoolean();
        this.allocationDelay = in.readOptionalTimeValue();
        this.targetNodeName = in.getVersion().onOrAfter(REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) ? in.readOptionalString() : null;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Type getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public long getStartedAtMillis() {
        return this.startedAtMillis;
    }

    public boolean getNodeSeen() {
        return this.nodeSeen;
    }

    public String getTargetNodeName() {
        return this.targetNodeName;
    }

    @Nullable
    public TimeValue getAllocationDelay() {
        if (this.allocationDelay != null) {
            return this.allocationDelay;
        }
        if (Type.RESTART.equals((Object)this.type)) {
            return DEFAULT_RESTART_SHARD_ALLOCATION_DELAY;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        if (out.getVersion().before(REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) && this.type == Type.REPLACE) {
            out.writeEnum(Type.REMOVE);
        } else {
            out.writeEnum(this.type);
        }
        out.writeString(this.reason);
        out.writeVLong(this.startedAtMillis);
        out.writeBoolean(this.nodeSeen);
        out.writeOptionalTimeValue(this.allocationDelay);
        if (out.getVersion().onOrAfter(REPLACE_SHUTDOWN_TYPE_ADDED_VERSION)) {
            out.writeOptionalString(this.targetNodeName);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NODE_ID_FIELD.getPreferredName(), this.nodeId);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(REASON_FIELD.getPreferredName(), this.reason);
        builder.timeField(STARTED_AT_MILLIS_FIELD.getPreferredName(), STARTED_AT_READABLE_FIELD, this.startedAtMillis);
        builder.field(NODE_SEEN_FIELD.getPreferredName(), this.nodeSeen);
        if (this.allocationDelay != null) {
            builder.field(ALLOCATION_DELAY_FIELD.getPreferredName(), this.allocationDelay.getStringRep());
        }
        if (this.targetNodeName != null) {
            builder.field(TARGET_NODE_NAME_FIELD.getPreferredName(), this.targetNodeName);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleNodeShutdownMetadata)) {
            return false;
        }
        SingleNodeShutdownMetadata that = (SingleNodeShutdownMetadata)o;
        return this.getStartedAtMillis() == that.getStartedAtMillis() && this.getNodeId().equals(that.getNodeId()) && this.getType() == that.getType() && this.getReason().equals(that.getReason()) && this.getNodeSeen() == that.getNodeSeen() && Objects.equals(this.allocationDelay, that.allocationDelay) && Objects.equals(this.targetNodeName, that.targetNodeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNodeId(), this.getType(), this.getReason(), this.getStartedAtMillis(), this.getNodeSeen(), this.allocationDelay, this.targetNodeName});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{").append("nodeId=[").append(this.nodeId).append(']').append(", type=[").append((Object)this.type).append("], reason=[").append(this.reason).append(']');
        if (this.allocationDelay != null) {
            stringBuilder.append(", allocationDelay=[").append(this.allocationDelay).append("]");
        }
        if (this.targetNodeName != null) {
            stringBuilder.append(", targetNodeName=[").append(this.targetNodeName).append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SingleNodeShutdownMetadata original) {
        if (original == null) {
            return SingleNodeShutdownMetadata.builder();
        }
        return new Builder().setNodeId(original.getNodeId()).setType(original.getType()).setReason(original.getReason()).setStartedAtMillis(original.getStartedAtMillis()).setNodeSeen(original.getNodeSeen()).setTargetNodeName(original.getTargetNodeName());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), STARTED_AT_MILLIS_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), NODE_SEEN_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.textOrNull(), ALLOCATION_DELAY_FIELD.getPreferredName()), ALLOCATION_DELAY_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TARGET_NODE_NAME_FIELD);
        DEFAULT_RESTART_SHARD_ALLOCATION_DELAY = TimeValue.timeValueMinutes(5L);
    }

    public static enum Type {
        REMOVE,
        RESTART,
        REPLACE;


        public static Type parse(String type) {
            if ("remove".equals(type.toLowerCase(Locale.ROOT))) {
                return REMOVE;
            }
            if ("restart".equals(type.toLowerCase(Locale.ROOT))) {
                return RESTART;
            }
            if ("replace".equals(type.toLowerCase(Locale.ROOT))) {
                return REPLACE;
            }
            throw new IllegalArgumentException("unknown shutdown type: " + type);
        }
    }

    public static class Builder {
        private String nodeId;
        private Type type;
        private String reason;
        private long startedAtMillis = -1L;
        private boolean nodeSeen = false;
        private TimeValue allocationDelay;
        private String targetNodeName;

        private Builder() {
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder setStartedAtMillis(long startedAtMillis) {
            this.startedAtMillis = startedAtMillis;
            return this;
        }

        public Builder setNodeSeen(boolean nodeSeen) {
            this.nodeSeen = nodeSeen;
            return this;
        }

        public Builder setAllocationDelay(TimeValue allocationDelay) {
            this.allocationDelay = allocationDelay;
            return this;
        }

        public Builder setTargetNodeName(String targetNodeName) {
            this.targetNodeName = targetNodeName;
            return this;
        }

        public SingleNodeShutdownMetadata build() {
            if (this.startedAtMillis == -1L) {
                throw new IllegalArgumentException("start timestamp must be set");
            }
            return new SingleNodeShutdownMetadata(this.nodeId, this.type, this.reason, this.startedAtMillis, this.nodeSeen, this.allocationDelay, this.targetNodeName);
        }
    }

    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        STALLED,
        COMPLETE;


        public static Status combine(Status ... statuses) {
            int statusOrd = -1;
            for (Status status : statuses) {
                if (status == COMPLETE) continue;
                statusOrd = Math.max(status.ordinal(), statusOrd);
            }
            if (statusOrd == -1) {
                return COMPLETE;
            }
            return Status.values()[statusOrd];
        }
    }
}

