/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.security.user.privileges.Role;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.XContentParser;

public final class GetRolesResponse {
    private final List<Role> roles;
    private final Map<String, Map<String, Object>> transientMetadataMap;

    GetRolesResponse(List<Role> roles, Map<String, Map<String, Object>> transientMetadataMap) {
        this.roles = Collections.unmodifiableList(roles);
        this.transientMetadataMap = Collections.unmodifiableMap(transientMetadataMap);
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Map<String, Map<String, Object>> getTransientMetadataMap() {
        return this.transientMetadataMap;
    }

    public Map<String, Object> getTransientMetadata(String roleName) {
        return this.transientMetadataMap.get(roleName);
    }

    public static GetRolesResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        ArrayList<Role> roles = new ArrayList<Role>();
        HashMap<String, Map<String, Object>> transientMetadata = new HashMap<String, Map<String, Object>>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            Tuple<Role, Map<String, Object>> roleAndTransientMetadata = Role.PARSER.parse(parser, parser.currentName());
            roles.add(roleAndTransientMetadata.v1());
            transientMetadata.put(roleAndTransientMetadata.v1().getName(), roleAndTransientMetadata.v2());
        }
        return new GetRolesResponse(roles, transientMetadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRolesResponse response = (GetRolesResponse)o;
        return Objects.equals(this.roles, response.roles) && Objects.equals(this.transientMetadataMap, response.transientMetadataMap);
    }

    public int hashCode() {
        return Objects.hash(this.roles, this.transientMetadataMap);
    }
}

