/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class InferenceStats
implements ToXContentObject {
    public static final String NAME = "inference_stats";
    public static final ParseField MISSING_ALL_FIELDS_COUNT = new ParseField("missing_all_fields_count", new String[0]);
    public static final ParseField INFERENCE_COUNT = new ParseField("inference_count", new String[0]);
    public static final ParseField CACHE_MISS_COUNT = new ParseField("cache_miss_count", new String[0]);
    public static final ParseField FAILURE_COUNT = new ParseField("failure_count", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ConstructingObjectParser<InferenceStats, Void> PARSER = new ConstructingObjectParser("inference_stats", true, a -> new InferenceStats((Long)a[0], (Long)a[1], (Long)a[2], (Long)a[3], (Instant)a[4]));
    private final long missingAllFieldsCount;
    private final long inferenceCount;
    private final long failureCount;
    private final long cacheMissCount;
    private final Instant timeStamp;

    private InferenceStats(Long missingAllFieldsCount, Long inferenceCount, Long failureCount, Long cacheMissCount, Instant instant) {
        this(InferenceStats.unboxOrZero(missingAllFieldsCount), InferenceStats.unboxOrZero(inferenceCount), InferenceStats.unboxOrZero(failureCount), InferenceStats.unboxOrZero(cacheMissCount), instant);
    }

    public InferenceStats(long missingAllFieldsCount, long inferenceCount, long failureCount, long cacheMissCount, Instant timeStamp) {
        this.missingAllFieldsCount = missingAllFieldsCount;
        this.inferenceCount = inferenceCount;
        this.failureCount = failureCount;
        this.cacheMissCount = cacheMissCount;
        this.timeStamp = timeStamp == null ? Instant.ofEpochMilli(Instant.now().toEpochMilli()) : Instant.ofEpochMilli(timeStamp.toEpochMilli());
    }

    public long getMissingAllFieldsCount() {
        return this.missingAllFieldsCount;
    }

    public long getInferenceCount() {
        return this.inferenceCount;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FAILURE_COUNT.getPreferredName(), this.failureCount);
        builder.field(INFERENCE_COUNT.getPreferredName(), this.inferenceCount);
        builder.field(CACHE_MISS_COUNT.getPreferredName(), this.cacheMissCount);
        builder.field(MISSING_ALL_FIELDS_COUNT.getPreferredName(), this.missingAllFieldsCount);
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timeStamp.toEpochMilli());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceStats that = (InferenceStats)o;
        return this.missingAllFieldsCount == that.missingAllFieldsCount && this.inferenceCount == that.inferenceCount && this.failureCount == that.failureCount && this.cacheMissCount == that.cacheMissCount && Objects.equals(this.timeStamp, that.timeStamp);
    }

    public int hashCode() {
        return Objects.hash(this.missingAllFieldsCount, this.inferenceCount, this.failureCount, this.cacheMissCount, this.timeStamp);
    }

    public String toString() {
        return "InferenceStats{missingAllFieldsCount=" + this.missingAllFieldsCount + ", inferenceCount=" + this.inferenceCount + ", failureCount=" + this.failureCount + ", cacheMissCount=" + this.cacheMissCount + ", timeStamp=" + this.timeStamp + '}';
    }

    private static long unboxOrZero(@Nullable Long value) {
        return value == null ? 0L : value;
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MISSING_ALL_FIELDS_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INFERENCE_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), FAILURE_COUNT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CACHE_MISS_COUNT);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
    }
}

