/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap.plugins;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.elasticsearch.cli.Terminal;

public final class LoggerTerminal
extends Terminal {
    private final ExtendedLoggerWrapper logger;
    private static final String FQCN = LoggerTerminal.class.getName();

    private LoggerTerminal(Logger logger) {
        super(System.lineSeparator());
        this.logger = new ExtendedLoggerWrapper((ExtendedLogger)((AbstractLogger)logger), logger.getName(), logger.getMessageFactory());
    }

    public static LoggerTerminal getLogger(String logger) {
        return new LoggerTerminal(LogManager.getLogger((String)logger));
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    @Override
    public String readText(String prompt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char[] readSecret(String prompt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char[] readSecret(String prompt, int maxLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getErrorWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void print(Terminal.Verbosity verbosity, String msg, boolean isError) {
        Level level;
        switch (verbosity) {
            case SILENT: {
                level = isError ? Level.ERROR : Level.WARN;
                break;
            }
            case VERBOSE: {
                level = Level.DEBUG;
                break;
            }
            default: {
                level = isError ? Level.WARN : Level.INFO;
            }
        }
        this.logger.logIfEnabled(FQCN, level, null, msg.trim(), (Throwable)null);
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }
}

