/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lz4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import org.elasticsearch.lz4.LZ4Constants;
import org.elasticsearch.lz4.LZ4SafeUtils;
import org.elasticsearch.lz4.LZ4Utils;
import org.elasticsearch.lz4.SafeUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ESLZ4Compressor
extends LZ4Compressor {
    private static final ThreadLocal<short[]> sixtyFourKBHashTable = ThreadLocal.withInitial(() -> new short[8192]);
    private static final ThreadLocal<int[]> biggerHashTable = ThreadLocal.withInitial(() -> new int[4096]);
    public static final LZ4Compressor INSTANCE = new ESLZ4Compressor();

    ESLZ4Compressor() {
    }

    static int compress64k(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destEnd) {
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int dOff = destOff;
        int anchor = srcOff;
        if (srcLen >= 13) {
            short[] hashTable = sixtyFourKBHashTable.get();
            Arrays.fill(hashTable, (short)0);
            int sOff = srcOff + 1;
            block0: while (true) {
                int excess;
                int ref;
                int forwardOff = sOff;
                int step = 1;
                int var16 = 1 << LZ4Constants.SKIP_STRENGTH;
                do {
                    sOff = forwardOff;
                    if ((forwardOff += (step = var16++ >>> LZ4Constants.SKIP_STRENGTH)) > mflimit) break block0;
                    excess = LZ4Utils.hash64k(SafeUtils.readInt(src, sOff));
                    ref = srcOff + SafeUtils.readShort(hashTable, excess);
                    SafeUtils.writeShort(hashTable, excess, sOff - srcOff);
                } while (!LZ4SafeUtils.readIntEquals(src, ref, sOff));
                excess = LZ4SafeUtils.commonBytesBackward(src, ref, sOff, srcOff, anchor);
                ref -= excess;
                int runLen = (sOff -= excess) - anchor;
                int tokenOff = dOff++;
                if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                if (runLen >= 15) {
                    SafeUtils.writeByte(dest, tokenOff, 240);
                    dOff = LZ4SafeUtils.writeLen(runLen - 15, dest, dOff);
                } else {
                    SafeUtils.writeByte(dest, tokenOff, runLen << 4);
                }
                LZ4SafeUtils.wildArraycopy(src, anchor, dest, dOff, runLen);
                dOff += runLen;
                while (true) {
                    SafeUtils.writeShortLE(dest, dOff, (short)(sOff - ref));
                    int matchLen = LZ4SafeUtils.commonBytes(src, ref += 4, sOff += 4, srcLimit);
                    if ((dOff += 2) + 6 + (matchLen >>> 8) > destEnd) {
                        throw new LZ4Exception("maxDestLen is too small");
                    }
                    sOff += matchLen;
                    if (matchLen >= 15) {
                        SafeUtils.writeByte(dest, tokenOff, SafeUtils.readByte(dest, tokenOff) | 0xF);
                        dOff = LZ4SafeUtils.writeLen(matchLen - 15, dest, dOff);
                    } else {
                        SafeUtils.writeByte(dest, tokenOff, SafeUtils.readByte(dest, tokenOff) | matchLen);
                    }
                    if (sOff > mflimit) {
                        anchor = sOff;
                        break block0;
                    }
                    SafeUtils.writeShort(hashTable, LZ4Utils.hash64k(SafeUtils.readInt(src, sOff - 2)), sOff - 2 - srcOff);
                    int h = LZ4Utils.hash64k(SafeUtils.readInt(src, sOff));
                    ref = srcOff + SafeUtils.readShort(hashTable, h);
                    SafeUtils.writeShort(hashTable, h, sOff - srcOff);
                    if (!LZ4SafeUtils.readIntEquals(src, sOff, ref)) {
                        anchor = sOff++;
                        continue block0;
                    }
                    tokenOff = dOff++;
                    SafeUtils.writeByte(dest, tokenOff, 0);
                }
                break;
            }
        }
        dOff = LZ4SafeUtils.lastLiterals(src, anchor, srcEnd - anchor, dest, dOff, destEnd);
        return dOff - destOff;
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        SafeUtils.checkRange(src, srcOff, srcLen);
        SafeUtils.checkRange(dest, destOff, maxDestLen);
        int destEnd = destOff + maxDestLen;
        if (srcLen < 65547) {
            return ESLZ4Compressor.compress64k(src, srcOff, srcLen, dest, destOff, destEnd);
        }
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int dOff = destOff;
        int sOff = srcOff + 1;
        int anchor = srcOff;
        int[] hashTable = biggerHashTable.get();
        Arrays.fill(hashTable, srcOff);
        block0: while (true) {
            int excess;
            int ref;
            int back;
            int forwardOff = sOff;
            int step = 1;
            int var18 = 1 << LZ4Constants.SKIP_STRENGTH;
            do {
                sOff = forwardOff;
                if ((forwardOff += (step = var18++ >>> LZ4Constants.SKIP_STRENGTH)) > mflimit) break block0;
                excess = LZ4Utils.hash(SafeUtils.readInt(src, sOff));
                ref = SafeUtils.readInt(hashTable, excess);
                back = sOff - ref;
                SafeUtils.writeInt(hashTable, excess, sOff);
            } while (back >= 65536 || !LZ4SafeUtils.readIntEquals(src, ref, sOff));
            excess = LZ4SafeUtils.commonBytesBackward(src, ref, sOff, srcOff, anchor);
            ref -= excess;
            int runLen = (sOff -= excess) - anchor;
            int tokenOff = dOff++;
            if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                throw new LZ4Exception("maxDestLen is too small");
            }
            if (runLen >= 15) {
                SafeUtils.writeByte(dest, tokenOff, 240);
                dOff = LZ4SafeUtils.writeLen(runLen - 15, dest, dOff);
            } else {
                SafeUtils.writeByte(dest, tokenOff, runLen << 4);
            }
            LZ4SafeUtils.wildArraycopy(src, anchor, dest, dOff, runLen);
            dOff += runLen;
            while (true) {
                SafeUtils.writeShortLE(dest, dOff, back);
                int matchLen = LZ4SafeUtils.commonBytes(src, ref + 4, sOff += 4, srcLimit);
                if ((dOff += 2) + 6 + (matchLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                sOff += matchLen;
                if (matchLen >= 15) {
                    SafeUtils.writeByte(dest, tokenOff, SafeUtils.readByte(dest, tokenOff) | 0xF);
                    dOff = LZ4SafeUtils.writeLen(matchLen - 15, dest, dOff);
                } else {
                    SafeUtils.writeByte(dest, tokenOff, SafeUtils.readByte(dest, tokenOff) | matchLen);
                }
                if (sOff > mflimit) {
                    anchor = sOff;
                    break block0;
                }
                SafeUtils.writeInt(hashTable, LZ4Utils.hash(SafeUtils.readInt(src, sOff - 2)), sOff - 2);
                int h = LZ4Utils.hash(SafeUtils.readInt(src, sOff));
                ref = SafeUtils.readInt(hashTable, h);
                SafeUtils.writeInt(hashTable, h, sOff);
                back = sOff - ref;
                if (back >= 65536 || !LZ4SafeUtils.readIntEquals(src, ref, sOff)) {
                    anchor = sOff++;
                    continue block0;
                }
                tokenOff = dOff++;
                SafeUtils.writeByte(dest, tokenOff, 0);
            }
            break;
        }
        dOff = LZ4SafeUtils.lastLiterals(src, anchor, srcEnd - anchor, dest, dOff, destEnd);
        return dOff - destOff;
    }

    @Override
    public int compress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dest, int destOff, int maxDestLen) {
        if (src.hasArray() && dest.hasArray()) {
            return this.compress(src.array(), srcOff + src.arrayOffset(), srcLen, dest.array(), destOff + dest.arrayOffset(), maxDestLen);
        }
        throw new AssertionError((Object)"Do not support compression on direct buffers");
    }
}

