/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect.impl.processorsupplier;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kafka.connect.impl.ReadKafkaConnectP;
import com.hazelcast.jet.kafka.connect.impl.processorsupplier.ReadKafkaConnectProcessorSupplier;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TaskMaxProcessorSupplier
implements ProcessorSupplier {
    private static final long serialVersionUID = 1L;
    private final ReadKafkaConnectProcessorSupplier supplier;
    private final int lastInitiallyActiveProcesorOrder;
    private final int startingProcessorOrder;

    TaskMaxProcessorSupplier(int startingProcessorOrder, int lastInitiallyActiveProcesorOrder, ReadKafkaConnectProcessorSupplier supplier) {
        this.startingProcessorOrder = startingProcessorOrder;
        this.lastInitiallyActiveProcesorOrder = lastInitiallyActiveProcesorOrder;
        this.supplier = supplier;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        this.supplier.init(context);
    }

    public boolean initIsCooperative() {
        return this.supplier.initIsCooperative();
    }

    public boolean closeIsCooperative() {
        return this.supplier.closeIsCooperative();
    }

    public void close(@Nullable Throwable error) throws Exception {
        this.supplier.close(error);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Collection<ReadKafkaConnectP<?>> processors = this.supplier.get(count);
        int processorOrder = this.startingProcessorOrder;
        for (ReadKafkaConnectP<?> processor : processors) {
            int thisOrder;
            processor.setActive((thisOrder = processorOrder++) <= this.lastInitiallyActiveProcesorOrder);
            processor.setProcessorOrder(thisOrder);
        }
        return processors;
    }
}

