/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect.impl.processorsupplier;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kafka.connect.impl.processorsupplier.ReadKafkaConnectProcessorSupplier;
import com.hazelcast.jet.kafka.connect.impl.processorsupplier.TaskMaxProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TaskMaxProcessorMetaSupplier
implements ProcessorMetaSupplier,
DataSerializable {
    private static final long serialVersionUID = 1L;
    private int tasksMax;
    private ReadKafkaConnectProcessorSupplier supplier;
    private transient boolean partitionedAddresses;
    private final Map<Address, Integer> startingProcessorOrderMap = new HashMap<Address, Integer>();
    private transient int localParallelism;
    private int lastInitiallyActiveProcessorOrder;

    public void setTasksMax(int tasksMax) {
        this.tasksMax = tasksMax;
    }

    public void setSupplier(ReadKafkaConnectProcessorSupplier supplier) {
        this.supplier = supplier;
    }

    public boolean isPartitionedAddresses() {
        return this.partitionedAddresses;
    }

    public void init(@Nonnull ProcessorMetaSupplier.Context context) {
        this.localParallelism = context.localParallelism();
        int totalParallelism = context.totalParallelism();
        if (totalParallelism < this.tasksMax) {
            throw new IllegalArgumentException("The requested parallelism of " + this.tasksMax + " is greater than the available parallelism of " + totalParallelism + " for Kafka Connect vertices. Please call setLocalParallelism(" + this.tasksMax + ") for Kafka Connect Source");
        }
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        if (!this.partitionedAddresses) {
            this.partitionedAddresses = true;
            this.partitionTasks(addresses);
        }
        int lastActive = this.lastInitiallyActiveProcessorOrder;
        return memberAddress -> {
            Integer startingProcessorOrder = this.startingProcessorOrderMap.get(memberAddress);
            if (startingProcessorOrder != null) {
                return new TaskMaxProcessorSupplier(startingProcessorOrder, lastActive, this.supplier);
            }
            return new ProcessorMetaSupplier.ExpectNothingProcessorSupplier();
        };
    }

    private void partitionTasks(List<Address> addresses) {
        ArrayList<Address> copiedAddresses = new ArrayList<Address>(addresses);
        Collections.shuffle(copiedAddresses);
        int taskCounter = 0;
        int processorOrder = 0;
        boolean allMembersAssigned = false;
        while (taskCounter < this.tasksMax && !allMembersAssigned) {
            int parallelismForMember;
            Address address = (Address)copiedAddresses.remove(0);
            if (copiedAddresses.isEmpty()) {
                parallelismForMember = this.tasksMax - taskCounter;
                allMembersAssigned = true;
            } else {
                parallelismForMember = this.localParallelism;
            }
            taskCounter += parallelismForMember;
            this.startingProcessorOrderMap.put(address, processorOrder);
            processorOrder += this.localParallelism;
        }
        this.lastInitiallyActiveProcessorOrder = taskCounter - 1;
    }

    Map<Address, Integer> getStartingProcessorOrderMap() {
        return this.startingProcessorOrderMap;
    }

    void setLocalParallelism(int localParallelism) {
        this.localParallelism = localParallelism;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.tasksMax);
        out.writeObject((Object)this.supplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.tasksMax = in.readInt();
        this.supplier = (ReadKafkaConnectProcessorSupplier)in.readObject();
    }
}

