/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect.impl.message;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.kafka.connect.impl.message.LateJoiningListener;
import com.hazelcast.jet.kafka.connect.impl.message.TaskConfigMessage;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.MessageListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TaskConfigPublisher {
    private final HazelcastInstance hazelcastInstance;
    private String topicName;
    private volatile ITopic<TaskConfigMessage> reliableTopic;
    private final List<UUID> listeners = new ArrayList<UUID>();

    public TaskConfigPublisher(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void createTopic(long executionId) {
        this.topicName = "__jet." + executionId;
        this.reliableTopic = this.hazelcastInstance.getReliableTopic(this.topicName);
    }

    public void addMessageListener(MessageListener<TaskConfigMessage> messageListener) {
        UUID uuid = this.reliableTopic.addMessageListener(new LateJoiningListener<TaskConfigMessage>(this.hazelcastInstance, this.topicName, messageListener));
        this.listeners.add(uuid);
    }

    public void publish(TaskConfigMessage taskConfigMessage) {
        this.reliableTopic.publish((Object)taskConfigMessage);
    }

    public void destroyTopic() {
        this.reliableTopic.destroy();
    }

    public void removeMessageListeners() {
        for (UUID listener : this.listeners) {
            this.reliableTopic.removeMessageListener(listener);
        }
    }
}

