/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect.impl;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.kafka.connect.impl.JetSourceTaskContext;
import com.hazelcast.jet.kafka.connect.impl.State;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;

public class TaskRunner {
    private final ILogger logger;
    private final String name;
    private final ReentrantLock taskLifecycleLock = new ReentrantLock();
    private final State state;
    private final SourceTaskFactory sourceTaskFactory;
    private volatile boolean running;
    private volatile boolean reconfigurationNeeded;
    private SourceTask task;
    private volatile Map<String, String> taskConfigReference;

    TaskRunner(String name, State state, SourceTaskFactory sourceTaskFactory) {
        this.name = name;
        this.state = state;
        this.sourceTaskFactory = sourceTaskFactory;
        this.logger = Logger.getLogger((String)(this.getClass().getName() + " " + name));
    }

    public List<SourceRecord> poll() {
        this.restartTaskIfNeeded();
        if (this.running) {
            return this.doPoll();
        }
        return Collections.emptyList();
    }

    public void stop() {
        try {
            this.taskLifecycleLock.lock();
            if (this.running) {
                this.logger.fine("Stopping task '" + this.name + "'");
                this.task.stop();
                this.logger.fine("Task '" + this.name + "' stopped");
            }
        }
        finally {
            this.running = false;
            this.taskLifecycleLock.unlock();
        }
    }

    private List<SourceRecord> doPoll() {
        try {
            List<SourceRecord> sourceRecords = this.task.poll();
            return sourceRecords == null ? Collections.emptyList() : sourceRecords;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    void restartTaskIfNeeded() {
        if (this.reconfigurationNeeded) {
            this.reconfigurationNeeded = false;
            try {
                this.stop();
            }
            catch (Exception ex) {
                this.logger.warning("Stopping task '" + this.name + "' failed but proceeding with re-start", (Throwable)ex);
            }
        }
        this.start();
    }

    public void updateTaskConfig(Map<String, String> taskConfig) {
        try {
            this.taskLifecycleLock.lock();
            if (!Objects.equals(this.taskConfigReference, taskConfig)) {
                this.logger.info("Updating task '" + this.name + "' configuration");
                this.taskConfigReference = taskConfig;
                this.reconfigurationNeeded = true;
            }
        }
        finally {
            this.taskLifecycleLock.unlock();
        }
    }

    private void start() {
        try {
            this.taskLifecycleLock.lock();
            if (!this.running) {
                Map<String, String> taskConfig = this.taskConfigReference;
                if (taskConfig != null) {
                    SourceTask taskLocal = this.sourceTaskFactory.create();
                    this.logger.info("Initializing task '" + this.name + "'");
                    taskLocal.initialize(new JetSourceTaskContext(taskConfig, this.state));
                    this.logger.info("Starting task '" + this.name + "'");
                    taskLocal.start(taskConfig);
                    this.task = taskLocal;
                    this.running = true;
                } else {
                    this.logger.finest("No task config for task '" + this.name + "'");
                }
            }
        }
        finally {
            this.taskLifecycleLock.unlock();
        }
    }

    public void commit() {
        if (this.running) {
            try {
                this.task.commit();
            }
            catch (InterruptedException e) {
                this.logger.warning("Interrupted while committing");
                Thread.currentThread().interrupt();
            }
        }
    }

    public void commitRecord(SourceRecord rec) {
        this.state.commitRecord(rec);
        try {
            if (this.running) {
                this.task.commitRecord(rec, null);
            }
        }
        catch (InterruptedException ie) {
            this.logger.warning("Interrupted while committing record");
            Thread.currentThread().interrupt();
        }
    }

    public State copyState() {
        State snapshot = new State();
        snapshot.load(this.state);
        return snapshot;
    }

    public void restoreState(State state) {
        this.state.load(state);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "TaskRunner{name='" + this.name + "'}";
    }

    void forceRestart() {
        this.reconfigurationNeeded = true;
    }

    @FunctionalInterface
    static interface SourceTaskFactory {
        public SourceTask create();
    }
}

