/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.websocket;

import com.hazelcast.webmonitor.websocket.MyConcurrentWebSocketSessionDecorator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.SessionLimitExceededException;

public class MyConcurrentWebSocketSessionDecorator
extends ConcurrentWebSocketSessionDecorator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyConcurrentWebSocketSessionDecorator.class);
    private final int sendTimeLimit;
    private final int bufferSizeLimit;
    private final OverflowStrategy overflowStrategy;
    @Nullable
    private Consumer<WebSocketMessage<?>> preSendCallback;
    private final Queue<WebSocketMessage<?>> buffer = new LinkedBlockingQueue();
    private final AtomicInteger bufferSize = new AtomicInteger();
    private volatile long sendStartTime;
    private volatile boolean limitExceeded;
    private volatile boolean closeInProgress;
    private final Lock flushLock = new ReentrantLock();
    private final Lock closeLock = new ReentrantLock();

    public MyConcurrentWebSocketSessionDecorator(WebSocketSession delegate, int sendTimeLimit, int bufferSizeLimit) {
        this(delegate, sendTimeLimit, bufferSizeLimit, OverflowStrategy.TERMINATE);
    }

    public MyConcurrentWebSocketSessionDecorator(WebSocketSession delegate, int sendTimeLimit, int bufferSizeLimit, OverflowStrategy overflowStrategy) {
        super(delegate, sendTimeLimit, bufferSizeLimit);
        this.sendTimeLimit = sendTimeLimit;
        this.bufferSizeLimit = bufferSizeLimit;
        this.overflowStrategy = overflowStrategy;
    }

    public int getSendTimeLimit() {
        return this.sendTimeLimit;
    }

    public int getBufferSizeLimit() {
        return this.bufferSizeLimit;
    }

    public int getBufferSize() {
        return this.bufferSize.get();
    }

    public long getTimeSinceSendStarted() {
        long start = this.sendStartTime;
        return start > 0L ? System.currentTimeMillis() - start : 0L;
    }

    public void setMessageCallback(Consumer<WebSocketMessage<?>> callback) {
        this.preSendCallback = callback;
    }

    public void sendMessage(WebSocketMessage<?> message) throws IOException {
        if (this.shouldNotSend()) {
            return;
        }
        this.buffer.add(message);
        this.bufferSize.addAndGet(message.getPayloadLength());
        if (this.preSendCallback != null) {
            this.preSendCallback.accept(message);
        }
        do {
            if (this.tryFlushMessageBuffer()) continue;
            if (log.isTraceEnabled()) {
                log.trace(String.format("Another send already in progress: session id '%s':, \"in-progress\" send time %d (ms), buffer size %d bytes", this.getId(), this.getTimeSinceSendStarted(), this.getBufferSize()));
            }
            this.checkSessionLimits();
            break;
        } while (!this.buffer.isEmpty() && !this.shouldNotSend());
    }

    private boolean shouldNotSend() {
        return this.limitExceeded || this.closeInProgress;
    }

    private boolean tryFlushMessageBuffer() throws IOException {
        if (this.flushLock.tryLock()) {
            try {
                WebSocketMessage message;
                while ((message = (WebSocketMessage)this.buffer.poll()) != null) {
                    if (this.shouldNotSend()) {
                        break;
                    }
                    this.bufferSize.addAndGet(-message.getPayloadLength());
                    this.sendStartTime = System.currentTimeMillis();
                    this.getDelegate().sendMessage(message);
                    this.sendStartTime = 0L;
                }
            }
            finally {
                this.sendStartTime = 0L;
                this.flushLock.unlock();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSessionLimits() {
        if (this.shouldNotSend() || !this.closeLock.tryLock()) return;
        try {
            if (this.getTimeSinceSendStarted() > (long)this.getSendTimeLimit()) {
                String format = "Send time %d (ms) for session '%s' exceeded the allowed limit %d";
                String reason = String.format(format, this.getTimeSinceSendStarted(), this.getId(), this.getSendTimeLimit());
                this.limitExceeded(reason);
                return;
            }
            if (this.getBufferSize() <= this.getBufferSizeLimit()) return;
            switch (this.overflowStrategy.ordinal()) {
                case 0: {
                    String format = "Buffer size %d bytes for session '%s' exceeds the allowed limit %d";
                    String reason = String.format(format, this.getBufferSize(), this.getId(), this.getBufferSizeLimit());
                    this.limitExceeded(reason);
                    return;
                }
                case 1: {
                    WebSocketMessage message;
                    int i = 0;
                    while (this.getBufferSize() > this.getBufferSizeLimit() && (message = (WebSocketMessage)this.buffer.poll()) != null) {
                        this.bufferSize.addAndGet(-message.getPayloadLength());
                        ++i;
                    }
                    if (!log.isDebugEnabled()) return;
                    log.debug("Dropped " + i + " messages, buffer size: " + this.getBufferSize());
                    return;
                }
                default: {
                    throw new IllegalStateException("Unexpected OverflowStrategy: " + String.valueOf(this.overflowStrategy));
                }
            }
        }
        finally {
            this.closeLock.unlock();
        }
    }

    private void limitExceeded(String reason) {
        this.limitExceeded = true;
        throw new SessionLimitExceededException(reason, CloseStatus.SESSION_NOT_RELIABLE.withReason(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CloseStatus status) throws IOException {
        this.closeLock.lock();
        try {
            if (this.closeInProgress) {
                return;
            }
            if (CloseStatus.SESSION_NOT_RELIABLE.getCode() != status.getCode()) {
                String reason = null;
                try {
                    this.checkSessionLimits();
                }
                catch (SessionLimitExceededException ex) {
                    reason = ex.getMessage();
                }
                if (this.limitExceeded) {
                    if (log.isDebugEnabled()) {
                        log.debug("Changing close status " + String.valueOf(status) + " to SESSION_NOT_RELIABLE.");
                    }
                    status = Optional.ofNullable(reason).map(arg_0 -> ((CloseStatus)CloseStatus.SESSION_NOT_RELIABLE).withReason(arg_0)).orElse(CloseStatus.SESSION_NOT_RELIABLE);
                }
            }
            this.closeInProgress = true;
            this.getDelegate().close(status);
        }
        finally {
            this.closeLock.unlock();
        }
    }

    public String toString() {
        return this.getDelegate().toString();
    }
}

