/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.util.LicenseHelper;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class LicenseHelperWrapper {
    public License getBuiltInLicense() {
        return LicenseHelper.getBuiltInLicense();
    }

    public boolean isBuiltInLicense(License license) {
        return LicenseHelper.isBuiltInLicense((License)license);
    }

    public License checkLicenseKeyPerFeature(String licenseKey, String versionString, Feature ... features) {
        InvalidLicenseException exception = null;
        License license = LicenseHelper.getLicense((String)licenseKey, (String)versionString);
        for (Feature feature : features) {
            try {
                LicenseHelper.checkLicensePerFeature((License)license, (Feature)feature);
                return license;
            }
            catch (InvalidLicenseException e) {
                exception = e;
            }
        }
        throw (InvalidLicenseException)Objects.requireNonNull(exception);
    }

    public boolean isExpired(License license) {
        return LicenseHelper.isExpired((License)license);
    }
}

