/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemUtil.class);

    private FileSystemUtil() {
    }

    public static void deleteDirectoryRecursively(Path path) throws IOException {
        try (Stream<Path> entries = Files.walk(path, new FileVisitOption[0]);){
            entries.sorted(Comparator.reverseOrder()).forEach(file -> {
                try {
                    Files.deleteIfExists(file);
                }
                catch (IOException e) {
                    log.error("Failed to delete file " + String.valueOf(path.toAbsolutePath()));
                }
            });
        }
    }
}

