/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.webmonitor.config.properties.SqlConfigurationProperties;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.sql.SqlRowSetProcessor;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import com.hazelcast.webmonitor.websocket.event.SessionDisconnectedEvent;
import com.hazelcast.webmonitor.websocket.event.SessionSubscribedEvent;
import com.hazelcast.webmonitor.websocket.event.SessionUnsubscribedEvent;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Service;

@Service
public class SqlRowSetProcessor
implements InitializingBean,
DisposableBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlRowSetProcessor.class);
    private static final int MAX_ROW_SET_PROCESSOR_THREAD_COUNT = 4;
    static final long PENDING_TASK_EXPIRATION_TIME = TimeUnit.MINUTES.toNanos(5L);
    public static final String USER_TOPIC_SQL_RESULTS = "/user/topic/sql-results/";
    private static final int MAX_DESERIALIZATION_EXCEPTION_LOG_RATE = 10;
    private static final Logger DESERIALIZATION_EXCEPTION_LOGGER = RateLimitedLog.withRateLimit((Logger)log).maxRate(10).every(Duration.of(1L, ChronoUnit.MINUTES)).build();
    private final Clock clock;
    private final SimpMessagingTemplate messagingTemplate;
    private final SqlConfigurationProperties sqlConfigurationProperties;
    private final ScheduledExecutorService iterationPool = Executors.newScheduledThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), 4), new ThreadFactoryBuilder().setNameFormat("SQLRowSetProcessor-%d").build());
    private final ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("PendingSqlIterationTasksCleaner").build());
    private final ConcurrentMap<String, Task> tasks = new ConcurrentHashMap();
    private final Set<String> pausedQueries = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<String, Set<String>> sessionQueries = new ConcurrentHashMap();

    public void afterPropertiesSet() {
        this.cleaner.scheduleAtFixedRate(() -> this.removeExpiredPendingTasks(), 1L, 1L, TimeUnit.MINUTES);
    }

    void removeExpiredPendingTasks() {
        this.tasks.forEach((key, value) -> this.tasks.computeIfPresent(key, (k, v) -> {
            if (v.isExpired()) {
                v.cancel();
                return null;
            }
            return v;
        }));
    }

    public void destroy() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.iterationPool);
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.cleaner);
    }

    public void addPendingTask(String queryId, String username, SqlClientResult sqlResult) {
        int size = sqlResult.getRowMetadata().getColumns().size();
        IteratingSqlRunnable runnable = new IteratingSqlRunnable(this, username, queryId, sqlResult, size);
        this.tasks.putIfAbsent(queryId, new Task(this, runnable));
    }

    public void pauseQuery(String queryId) {
        this.pausedQueries.add(queryId);
    }

    public void resumeQuery(String queryId) {
        this.pausedQueries.remove(queryId);
    }

    @EventListener
    public void onSessionSubscribed(SessionSubscribedEvent event) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String destination = accessor.getFirstNativeHeader("simpOrigDestination");
        if (destination != null && destination.startsWith(USER_TOPIC_SQL_RESULTS)) {
            String queryId = destination.substring(destination.lastIndexOf(47) + 1);
            String subscriptionId = accessor.getSubscriptionId();
            String sessionId = accessor.getSessionId();
            log.debug("Subscribed: queryId = {} subscriptionId = {} sessionId = {}", new Object[]{queryId, subscriptionId, sessionId});
            this.tasks.computeIfPresent(queryId, (k, pendingTask) -> {
                this.sessionQueries.computeIfAbsent(sessionId, id -> Collections.newSetFromMap(new ConcurrentHashMap())).add(queryId);
                return pendingTask.activate(sessionId);
            });
        }
    }

    @EventListener
    public void onSessionUnsubscribed(SessionUnsubscribedEvent event) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String destination = accessor.getFirstNativeHeader("simpOrigDestination");
        if (destination != null && destination.startsWith(USER_TOPIC_SQL_RESULTS)) {
            String queryId = destination.substring(destination.lastIndexOf(47) + 1);
            String subscriptionId = accessor.getSubscriptionId();
            String sessionId = accessor.getSessionId();
            log.debug("Unsubscribed: queryId = {} subscriptionId = {} sessionId = {}", new Object[]{queryId, subscriptionId, sessionId});
            this.sessionQueries.computeIfPresent(sessionId, (k, v) -> {
                if (v.remove(queryId)) {
                    this.cancelExecution(queryId);
                }
                return v;
            });
        }
    }

    @EventListener
    public void onSessionDisconnected(SessionDisconnectedEvent event) {
        String sessionId = event.getSessionId();
        this.sessionQueries.computeIfPresent(sessionId, (k, queryIds) -> {
            queryIds.forEach(arg_0 -> this.cancelExecution(arg_0));
            return null;
        });
        log.debug("Disconnected: sessionId = {}", (Object)sessionId);
    }

    void cancelExecution(String queryId) {
        Task task = (Task)this.tasks.remove(queryId);
        if (task != null) {
            task.cancel();
        }
    }

    long pendingTasksSize() {
        return this.tasks.values().stream().filter(it -> !it.active).count();
    }

    long activeTasksSize() {
        return this.tasks.values().stream().filter(it -> it.active).count();
    }

    long pausedQuerySize() {
        return this.pausedQueries.size();
    }

    ConcurrentMap<String, Set<String>> sessionQueries() {
        return this.sessionQueries;
    }

    Set<String> sessionQueries(String sessionId) {
        return Optional.ofNullable((Set)this.sessionQueries.get(sessionId)).orElse(Collections.emptySet());
    }

    @ConstructorProperties(value={"clock", "messagingTemplate", "sqlConfigurationProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SqlRowSetProcessor(Clock clock, SimpMessagingTemplate messagingTemplate, SqlConfigurationProperties sqlConfigurationProperties) {
        this.clock = clock;
        this.messagingTemplate = messagingTemplate;
        this.sqlConfigurationProperties = sqlConfigurationProperties;
    }
}

