/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.session;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionUtil.class);

    public static String extractRedirectUrl(HttpSession session) {
        try {
            Optional<String> redirectUrl = Optional.ofNullable((String)session.getAttribute("redirectUrl"));
            session.removeAttribute("redirectUrl");
            return redirectUrl.orElse("/");
        }
        catch (IllegalStateException e) {
            log.error("Failed to extract redirect URL due to invalidated session.", (Throwable)e);
            return "/";
        }
    }

    public static void tryInvalidateRedirectUrl(HttpSession session, String queryRequest) {
        try {
            String decodedQueryString = URLDecoder.decode(queryRequest, StandardCharsets.UTF_8);
            URI uri = new URI("http://dummy-host:8080" + decodedQueryString);
            String query = uri.getQuery();
            if (query == null) {
                session.removeAttribute("redirectUrl");
            }
        }
        catch (Exception e) {
            log.error("URI creation exception.", (Throwable)e);
            session.removeAttribute("redirectUrl");
        }
    }

    public static void setAttribute(HttpSession session, String key, String value) {
        try {
            session.setAttribute(key, (Object)value);
        }
        catch (IllegalStateException e) {
            log.error("Failed to put attribute to session due to invalidated session.", (Throwable)e);
        }
    }

    private SessionUtil() {
    }
}

