/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeDataSupplier;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PhoneHomeService
implements InitializingBean,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhoneHomeService.class);
    private static final int INITIAL_DELAY_MINUTES = 30;
    private static final int TIMEOUT_MILLIS = 5000;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "PhoneHomeService"));
    private final String phoneHomeUrl;
    private final PhoneHomeDataSupplier phoneHomeDataSupplier;
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().build();
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();

    public void afterPropertiesSet() {
        this.executor.scheduleAtFixedRate(() -> this.sendData(), 30L, TimeUnit.DAYS.toMinutes(1L), TimeUnit.MINUTES);
    }

    @Override
    public void close() throws IOException {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executor);
        this.httpClient.close();
    }

    public void sendData() {
        try {
            PhoneHomeData phoneHomeData = this.phoneHomeDataSupplier.get();
            StringEntity entity = new StringEntity(SerializationUtil.OBJECT_MAPPER.writeValueAsString((Object)phoneHomeData), ContentType.APPLICATION_JSON);
            HttpUriRequest request = RequestBuilder.post((String)this.phoneHomeUrl).setConfig(this.requestConfig).setEntity((HttpEntity)entity).build();
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                log.debug("Response from PhoneHome: {}", (Object)response.getStatusLine());
            }
        }
        catch (Exception e) {
            log.debug("Phone home failed.", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"phoneHomeUrl", "phoneHomeDataSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PhoneHomeService(String phoneHomeUrl, PhoneHomeDataSupplier phoneHomeDataSupplier) {
        this.phoneHomeUrl = phoneHomeUrl;
        this.phoneHomeDataSupplier = phoneHomeDataSupplier;
    }
}

