/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.repositories.sql.InstanceDataDAO;
import com.hazelcast.webmonitor.service.BrowserHeartBeatEvent;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import com.hazelcast.webmonitor.service.telemetry.InstanceData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.EventListener;

public class InstanceDataTracker
implements InitializingBean,
DataCollector {
    static final int HEARTBEAT_EXPIRATION_SECONDS = 120;
    private final InstanceDataDAO dao;
    private final Clock clock;

    public void afterPropertiesSet() {
        this.getOrCreateInstanceData();
    }

    private InstanceData getOrCreateInstanceData() {
        Optional instanceData = this.dao.find();
        if (instanceData.isEmpty()) {
            InstanceData newData = new InstanceData(UuidUtil.newSecureUUID(), this.clock.instant(), null);
            this.dao.insert(newData);
            return newData;
        }
        return (InstanceData)instanceData.get();
    }

    public void collectInto(PhoneHomeData data) {
        InstanceData instanceData = this.getOrCreateInstanceData();
        data.setMcInstanceId(instanceData.getInstanceId());
        data.setInstallationDate(instanceData.getInstallationDate().getEpochSecond());
        long now = this.clock.instant().getEpochSecond();
        Instant lastWebActivityTimestamp = instanceData.getLastWebActivity();
        if (this.sessionIsAliveBasedOnLastHeartBeat(now, lastWebActivityTimestamp)) {
            data.setLastWebActivity(now);
        } else {
            data.setLastWebActivity(lastWebActivityTimestamp == null ? 0L : lastWebActivityTimestamp.getEpochSecond());
        }
    }

    private boolean sessionIsAliveBasedOnLastHeartBeat(long now, Instant lastWebActivityTimestamp) {
        return lastWebActivityTimestamp != null && now - lastWebActivityTimestamp.getEpochSecond() < 120L;
    }

    @EventListener(value={BrowserHeartBeatEvent.class})
    public void browserHeartBeatReceived() {
        InstanceData instanceData = this.getOrCreateInstanceData();
        Instant now = this.clock.instant();
        this.dao.update(instanceData.withLastWebActivity(now));
    }

    @ConstructorProperties(value={"dao", "clock"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public InstanceDataTracker(InstanceDataDAO dao, Clock clock) {
        this.dao = dao;
        this.clock = clock;
    }
}

