/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.events.model.ConfigUpdateSucceededEvent;
import com.hazelcast.webmonitor.events.model.WanConfigUpdateSucceededEvent;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigFactory;
import com.hazelcast.webmonitor.utils.MemberUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class MemberConfigService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberConfigService.class);
    static final int MEMBER_CONFIG_CACHE_MAX_SIZE = 1000;
    private final OperationDispatcher dispatcher;
    private final MCConfigurationProperties mcProperties;
    private final MemberConfigFactory memberConfigFactory;
    private final ConcurrentMap<String, LoadingCache<String, MemberConfig>> caches = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentMap<String, String>> memberConfigFileContents = new ConcurrentHashMap();

    @EventListener
    public void onMembersJoined(MembersJoinedEvent event) {
        String cluster = event.getCluster();
        Set members = event.getJoinedMembers();
        Set memberAddresses = members.stream().map(MemberUtil::getMemberAddress).collect(Collectors.toSet());
        this.getClusterCache(cluster).refreshAll(memberAddresses);
        this.populateConfigFileContents(cluster, memberAddresses);
    }

    @EventListener
    public void onMemberRemoved(MemberRemovedEvent event) {
        String cluster = event.getCluster();
        Member member = event.getRemovedMember();
        String key = MemberUtil.getMemberAddress((Member)member);
        this.getClusterCache(cluster).asMap().remove(key);
        this.memberConfigFileContents.computeIfPresent(cluster, (clusterName, membersMap) -> {
            membersMap.remove(key);
            return membersMap;
        });
    }

    @EventListener
    public void onClusterDisconnected(DisconnectedFromClusterEvent event) {
        this.removeCluster(event.getCluster());
    }

    @EventListener
    public void onDynamicConfigUpdateSucceeded(ConfigUpdateSucceededEvent event) {
        String clusterName = event.memberIdent().getClusterName();
        this.reloadConfigs(clusterName);
    }

    @EventListener
    public void onWanConfigurationUpdated(WanConfigUpdateSucceededEvent event) {
        this.reloadConfigs(event.memberIdent().getClusterName());
    }

    private LoadingCache<String, MemberConfig> getClusterCache(String clusterName) {
        return this.caches.computeIfAbsent(clusterName, ignored -> Caffeine.newBuilder().maximumSize(1000L).build(key -> {
            String rawXml;
            try {
                rawXml = (String)this.dispatcher.executeOnMember(MemberIdentifier.of((String)clusterName, (String)key), MCClient::getMemberConfig, e -> String.format("Failed to get member config for cluster = %s, member address = %s", clusterName, key));
            }
            catch (Exception e2) {
                log.warn("Couldn't load member config", (Throwable)e2);
                return null;
            }
            log.debug("Config was loaded for {} of cluster {}", key, (Object)clusterName);
            return this.memberConfigFactory.createMemberConfig(rawXml);
        }));
    }

    public MemberConfig getMemberConfig(MemberIdentifier memberIdent) {
        MemberConfig config = (MemberConfig)this.asMap().get(memberIdent);
        LoadingCache cache = (LoadingCache)this.caches.get(memberIdent.getClusterName());
        if (config == null && cache != null) {
            cache.refresh((Object)memberIdent.getMemberAddress());
        }
        return config;
    }

    public Map<String, EventJournalConfig> getMapEventJournalConfigs(String cluster) {
        return this.getClusterCache(cluster).asMap().values().stream().map(MemberConfig::toEffectiveConfig).flatMap(it -> it.getMapConfigs().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, it -> ((MapConfig)it.getValue()).getEventJournalConfig(), (jC1, jC2) -> jC1));
    }

    public Optional<MemberConfig> getRandomConfigFromCluster(String cluster) {
        return this.getClusterCache(cluster).asMap().values().stream().findAny();
    }

    public Map<MemberIdentifier, MemberConfig> asMap() {
        HashMap<MemberIdentifier, MemberConfig> rval = new HashMap<MemberIdentifier, MemberConfig>();
        this.caches.forEach((cluster, cache) -> cache.asMap().forEach((memberAddress, config) -> rval.put(MemberIdentifier.of((String)cluster, (String)memberAddress), (MemberConfig)config)));
        return rval;
    }

    public Map<MemberIdentifier, MemberConfig> asMap(String cluster) {
        HashMap<MemberIdentifier, MemberConfig> rval = new HashMap<MemberIdentifier, MemberConfig>();
        this.getClusterCache(cluster).asMap().forEach((memberAddress, config) -> rval.put(MemberIdentifier.of((String)cluster, (String)memberAddress), (MemberConfig)config));
        return rval;
    }

    public Map<String, String> getConfigFileContents(String cluster) {
        return this.memberConfigFileContents.getOrDefault(cluster, new ConcurrentHashMap());
    }

    private void removeCluster(String cluster) {
        LoadingCache cache = (LoadingCache)this.caches.remove(cluster);
        this.memberConfigFileContents.remove(cluster);
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    public void reloadConfigs(String cluster) {
        try {
            CompletableFuture[] futures = (CompletableFuture[])this.getClusterCache(cluster).asMap().keySet().stream().map(address -> MemberIdentifier.of((String)cluster, (String)address)).map(memberIdent -> this.dispatcher.asyncExecuteOnMember(memberIdent, MCClient::getMemberConfig).thenAccept(newConfigXml -> this.getClusterCache(memberIdent.getClusterName()).put((Object)memberIdent.getMemberAddress(), (Object)this.memberConfigFactory.createMemberConfig(newConfigXml)))).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).get(this.mcProperties.getClusterOperationTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void populateConfigFileContents(String cluster, Set<String> memberAddresses) {
        memberAddresses.forEach(memberAddress -> this.dispatcher.asyncExecuteOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), (mcClient, member) -> mcClient.getMemberConfigurationFileContent(member).thenAccept(content -> {
            if (content == null) {
                return;
            }
            this.memberConfigFileContents.computeIfAbsent(cluster, k -> new ConcurrentHashMap()).put(memberAddress, content);
        })));
    }

    @VisibleForTesting
    ConcurrentMap<String, LoadingCache<String, MemberConfig>> getCaches() {
        return this.caches;
    }

    @VisibleForTesting
    ConcurrentMap<String, ConcurrentMap<String, String>> getMemberConfigFileContents() {
        return this.memberConfigFileContents;
    }

    @VisibleForTesting
    void invalidateClusterConfigCache(String cluster) {
        this.getClusterCache(cluster).invalidateAll();
    }

    @ConstructorProperties(value={"dispatcher", "mcProperties", "memberConfigFactory"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberConfigService(OperationDispatcher dispatcher, MCConfigurationProperties mcProperties, MemberConfigFactory memberConfigFactory) {
        this.dispatcher = dispatcher;
        this.mcProperties = mcProperties;
        this.memberConfigFactory = memberConfigFactory;
    }
}

