/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.google.common.base.Suppliers;
import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.utils.XmlUtil;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class MemberConfig {
    private final String rawXmlConfig;
    private final Supplier<Config> effectiveConfig;

    public MemberConfig(@Nonnull String rawXmlConfig) {
        this.rawXmlConfig = rawXmlConfig;
        String processedXmlConfig = XmlUtil.maskXPathExpressionsInXml((String)XmlUtil.removeUrlNodes((String)rawXmlConfig), (String)"none", List.of("/hazelcast/security/realms/realm/identity/token/@encoding"));
        this.effectiveConfig = Suppliers.memoize(() -> new SchemaIgnoringXmlConfigBuilder(new ByteArrayInputStream(processedXmlConfig.getBytes(StandardCharsets.UTF_8))).build());
    }

    public String getRawXmlConfig() {
        return this.rawXmlConfig;
    }

    public Config toEffectiveConfig() {
        return (Config)this.effectiveConfig.get();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberConfig)) {
            return false;
        }
        MemberConfig that = (MemberConfig)o;
        return Objects.equals(this.rawXmlConfig, that.rawXmlConfig);
    }

    public final int hashCode() {
        return Objects.hash(this.rawXmlConfig);
    }
}

