/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.ClientNearCacheStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.NearCacheStatsMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.JMXServiceImpl;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.management.ObjectName;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NearCacheStatsMXBeanImpl
implements NearCacheStatsMXBean,
BaseManagementBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NearCacheStatsMXBeanImpl.class);
    private static final String TYPE_NAME = "ClientStats";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String uuid;
    private final String dataStructureName;
    private final InstanceType type;
    private volatile ClientNearCacheStatsDTO stats;

    public NearCacheStatsMXBeanImpl(ClusteredStatsService statsService, String cluster, String uuid, String dataStructureName, InstanceType type) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.uuid = uuid;
        this.dataStructureName = dataStructureName;
        this.type = type;
    }

    static String getName(String clientUuid, InstanceType type, String dataStructureName) {
        return clientUuid + "#" + type.name() + "#" + dataStructureName;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectNameOrNull((String)("ManagementCenter[" + this.cluster + "]:type=ClientStats,uuid=" + JMXServiceImpl.quote((String)this.uuid) + ",subtype=" + JMXServiceImpl.quote((String)"NearCacheStats") + ",nearCacheStatType=" + String.valueOf(this.type) + "," + this.type.name().toLowerCase() + "Name=" + JMXServiceImpl.quote((String)this.dataStructureName)));
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        if (state.getClientsPerUuid().get(this.uuid) == null) {
            log.debug("Client with uuid {} is not available anymore", (Object)this.uuid);
            return;
        }
        this.stats = this.statsService.getNearCacheStats(this.cluster, this.uuid, this.type, this.dataStructureName);
    }

    public String getName() {
        return NearCacheStatsMXBeanImpl.getName((String)this.uuid, (InstanceType)this.type, (String)this.dataStructureName);
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getCreationTime);
    }

    public long getEvictions() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getEvictions);
    }

    public long getHits() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getHits);
    }

    public long getMisses() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getMisses);
    }

    public long getOwnedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getOwnedEntryCount);
    }

    public long getExpirations() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getExpirations);
    }

    public long getOwnedEntryMemoryCost() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getOwnedEntryMemoryCost);
    }

    public long getLastPersistenceDuration() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getLastPersistenceDuration);
    }

    public long getLastPersistenceKeyCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getLastPersistenceKeyCount);
    }

    public long getLastPersistenceTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getLastPersistenceTime);
    }

    public long getLastPersistenceWrittenBytes() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientNearCacheStatsDTO::getLastPersistenceWrittenBytes);
    }
}

