/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jet;

import com.hazelcast.webmonitor.controller.dto.jet.EdgeInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ExportedJobSnapshotDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobStatsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.MinimizedJobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.TaskCountsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.VertexInfoDTO;
import com.hazelcast.webmonitor.service.jet.EdgeLookup;
import com.hazelcast.webmonitor.service.jet.JobManager;
import com.hazelcast.webmonitor.service.jet.VertexManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class JetService {
    private final JobManager jobManager;
    private final VertexManager vertexManager;
    private final EdgeLookup edgeLookup;

    public List<MinimizedJobInfoDTO> getJobs(String cluster) {
        return this.jobManager.getJobs(cluster);
    }

    public JobInfoDTO getJobInfo(String cluster, String id) {
        return this.jobManager.getJobInfo(cluster, id);
    }

    public VertexInfoDTO getVertexDetails(String cluster, String jobId, String vertex) {
        return this.vertexManager.getVertexDetails(cluster, jobId, vertex);
    }

    public EdgeInfoDTO lookUpEdgeInfo(String cluster, String id, String sourceVertex, int fromOrdinal, String targetVertex, int toOrdinal) {
        return this.edgeLookup.lookUpEdgeInfo(cluster, id, sourceVertex, fromOrdinal, targetVertex, toOrdinal);
    }

    public List<ExportedJobSnapshotDTO> getExportedSnapshots(String cluster) {
        return this.jobManager.getExportedSnapshots(cluster);
    }

    public TaskCountsDTO getTaskCounts(String cluster) {
        return this.jobManager.getTaskCounts(cluster);
    }

    public JobStatsDTO getAggregateJobStats(String cluster, long time) {
        return this.jobManager.getAggregateJobStats(cluster, time);
    }

    @ConstructorProperties(value={"jobManager", "vertexManager", "edgeLookup"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JetService(JobManager jobManager, VertexManager vertexManager, EdgeLookup edgeLookup) {
        this.jobManager = jobManager;
        this.vertexManager = vertexManager;
        this.edgeLookup = edgeLookup;
    }
}

