/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MinRequiredVersion;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.VersionRestriction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
class VersionCheckAspect {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionCheckAspect.class);
    private final ClusterManager clusterManager;
    private final MemberManager memberManager;

    @Around(value="execution(AnalysisOutcome Analyzer+.analyze(SourceDataFilter, IgnoreList)) && args(filter, ignoreList)&& @target(annotation)")
    private Object checkVersion(ProceedingJoinPoint pjp, MinRequiredVersion annotation, SourceDataFilter filter, IgnoreList ignoreList) throws Throwable {
        Analyzer analyzer = (Analyzer)pjp.getThis();
        String clusterName = filter.getCluster();
        VersionRestriction.VersionCheckType checkType = annotation.type();
        String requiredVersionString = annotation.value();
        try {
            boolean isVersionLessThanMinRequired;
            Version minRequiredVersion = Version.of((String)requiredVersionString);
            boolean bl = isVersionLessThanMinRequired = checkType == VersionRestriction.VersionCheckType.CLUSTER ? this.clusterVersionIsLessThanMinRequired(clusterName, minRequiredVersion) : this.someMemberHasVersionLessThanMinRequired(clusterName, minRequiredVersion);
            if (isVersionLessThanMinRequired) {
                return AnalysisOutcome.withMinRequiredVersion((String)analyzer.getCheckId(), (String)analyzer.describeSelf(), (VersionRestriction)new VersionRestriction(requiredVersionString, checkType));
            }
        }
        catch (Exception e) {
            String analyzerName = analyzer.getClass().getSimpleName();
            log.warn("Exception occurred while checking minimum version for analyzer {}", (Object)analyzerName, (Object)e);
            return AnalysisOutcome.withProblems((String)analyzer.getCheckId(), (String)analyzer.describeSelf(), List.of(new ClusterWideProblem(String.format("Exception occurred while checking minimum version for analyzer %s. Please check your server logs", analyzerName), "", Problem.ProblemType.FAIL)));
        }
        return pjp.proceed();
    }

    private boolean clusterVersionIsLessThanMinRequired(String clusterName, Version minRequiredVersion) {
        String clusterVersion = this.clusterManager.clusterVersion(clusterName);
        if (clusterVersion == null) {
            return false;
        }
        return !Version.of((String)clusterVersion).isGreaterOrEqual(minRequiredVersion);
    }

    private boolean someMemberHasVersionLessThanMinRequired(String clusterName, Version minRequiredVersionStr) {
        return this.memberManager.getMemberVersions(clusterName).stream().anyMatch(memberVersion -> !memberVersion.isGreaterOrEqual(minRequiredVersionStr));
    }

    @ConstructorProperties(value={"clusterManager", "memberManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public VersionCheckAspect(ClusterManager clusterManager, MemberManager memberManager) {
        this.clusterManager = clusterManager;
        this.memberManager = memberManager;
    }
}

