/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.AttributeComparisonDispatcher;
import com.hazelcast.webmonitor.service.healthcheck.EqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SecurityAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.List;
import java.util.Map;

class SecurityAttributeEqualityAnalyzer
extends EqualityAnalyzer {
    SecurityAttributeEqualityAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    protected List<Problem> identifyProblems(Map<MemberIdentifier, Config> effectiveConfigs) {
        return AttributeComparisonDispatcher.dispatch((Map)this.extractConfigAttribute(effectiveConfigs, Config::getSecurityConfig), membersByValues -> new SecurityAttributeEquivalence(membersByValues, effectiveConfigs));
    }

    public String describeSelf() {
        return "Checking if Security is configured in the same way across members";
    }

    String getCheckId() {
        return AnalyzerCheckId.SECURITY_ATTRIBUTE_EQUALITY_ANALYZER.getCheckId();
    }
}

