/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PreconditionCheckingAnalyzer
implements AnalysisOutcomeSource {
    private final List<Analyzer> preconditions;
    private final List<Analyzer> furtherAnalyzers;

    PreconditionCheckingAnalyzer(List<Analyzer> preconditions, List<Analyzer> furtherAnalyzers, EnumSet<AnalyzerCheckId> excludedChecks) {
        Set excludedCheckIds = excludedChecks.stream().map(AnalyzerCheckId::getCheckId).collect(Collectors.toSet());
        boolean isPreconditionExcluded = preconditions.stream().anyMatch(p -> excludedCheckIds.contains(p.getCheckId()));
        if (isPreconditionExcluded) {
            throw new IllegalArgumentException("At least one of the preconditions is excluded in PreconditionCheckingAnalyzer. The analyzer will be omitted from Healthcheck.");
        }
        List<Analyzer> includedFurtherAnalyzers = furtherAnalyzers.stream().filter(f -> !excludedCheckIds.contains(f.getCheckId())).toList();
        this.preconditions = preconditions;
        this.furtherAnalyzers = includedFurtherAnalyzers;
    }

    public Stream<AnalysisOutcome> getOutcomes(SourceDataFilter filter, IgnoreList ignoreList) {
        Stream.Builder<AnalysisOutcome> outcomes = Stream.builder();
        for (Analyzer precondition : this.preconditions) {
            AnalysisOutcome preconditionOutcome = precondition.analyze(filter, ignoreList);
            if (!preconditionOutcome.isSuccessful()) {
                return Stream.of(preconditionOutcome);
            }
            outcomes.add(preconditionOutcome);
        }
        this.furtherAnalyzers.stream().flatMap(a -> a.getOutcomes(filter, ignoreList)).forEach(outcomes::add);
        return outcomes.build();
    }
}

