/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.CPMapAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.CPSubsystemConfigEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.CacheAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ConditionalOnCheckId;
import com.hazelcast.webmonitor.service.healthcheck.JetConfigAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ManagementCenterConfigAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ProcessorCountEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.QueueAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ReliableTopicAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SecurityAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SerializationConfigEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.TopicAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.TpcAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.WanReplicationAttributeEquivalenceAnalyzer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"!hzcloud"})
public class MemberAttributeEqualityAnalyzerConfig {
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CACHE_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer cacheAttributeEquivalenceAnalyzer(SourceDataSubscriptionPool pool) {
        return new CacheAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.SERIALIZATION_CONFIG_EQUALITY_ANALYZER)
    Analyzer serializationAnalyzer(SourceDataSubscriptionPool pool) {
        return new SerializationConfigEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.SECURITY_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer securityAnalyzer(SourceDataSubscriptionPool pool) {
        return new SecurityAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.QUEUE_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer queueConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new QueueAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.TOPIC_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer topicConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new TopicAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.RELIABLE_TOPIC_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer reliableTopicConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new ReliableTopicAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.WAN_REPLICATION_ATTRIBUTE_EQUIVALENCE_ANALYZER)
    Analyzer wanReplicationConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new WanReplicationAttributeEquivalenceAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.JET_CONFIG_ATTRIBUTE_EQUIVALENCE)
    Analyzer jetConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new JetConfigAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MANAGEMENT_CENTER_CONFIG_ATTRIBUTE_EQUIVALENCE)
    Analyzer managementCenterConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new ManagementCenterConfigAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.TPC_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer tpcAttributeEqualityAnalyzer(SourceDataSubscriptionPool pool) {
        return new TpcAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CP_MAP_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer cpMapAttributeEqualityAnalyzer(SourceDataSubscriptionPool pool) {
        return new CPMapAttributeEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.CP_SUBSYSTEM_ATTRIBUTE_EQUALITY_ANALYZER)
    Analyzer cpSubsystemAttributeEqualityAnalyzer(SourceDataSubscriptionPool pool) {
        return new CPSubsystemConfigEqualityAnalyzer(pool);
    }

    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.PROCESSOR_COUNT_EQUALITY_ANALYZER)
    Analyzer processorCountEqualityAnalyzer(SourceDataSubscriptionPool pool) {
        return new ProcessorCountEqualityAnalyzer(pool);
    }
}

