/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MapQueryCacheListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MapQueryCacheListEquivalence
extends ListEquivalence<MapConfig, QueryCacheConfig, String> {
    private final String mapName;

    private static QueryCacheConfig findQueryCacheConfig(Config config, String mapName, String queryCacheName) {
        return config.getMapConfig(mapName).getQueryCacheConfigs().stream().filter(c -> queryCacheName.equals(c.getName())).findAny().orElseThrow(() -> new IllegalStateException(String.format("query cache %s of map %s not found", queryCacheName, mapName)));
    }

    MapQueryCacheListEquivalence(Map<MemberIdentifier, Config> memberConfigs, String mapName) {
        super(memberConfigs, true);
        this.mapName = mapName;
    }

    AttributeEquivalence<QueryCacheConfig> createElementAttributeEquivalence(String queryCacheName, Map<QueryCacheConfig, Set<MemberIdentifier>> groupsByValues) {
        return new QueryCacheAttributeEquivalence(this, groupsByValues, queryCacheName);
    }

    MemberComparisonProblem createProblemForMissingElement(String elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.missingListElement((String)"query cache", (String)elemId, (String)("map " + this.mapName), membersContainingTheElem, membersMissingTheElem);
    }

    MapConfig extractOwner(Config config) {
        return config.getMapConfig(this.mapName);
    }

    Map<String, QueryCacheConfig> extractElements(MapConfig owner) {
        HashMap<String, QueryCacheConfig> rval = new HashMap<String, QueryCacheConfig>();
        owner.getQueryCacheConfigs().forEach(query -> rval.put(query.getName(), (QueryCacheConfig)query));
        return rval;
    }
}

