/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class MapDiskTierAnalyzer
extends SourceDataPoolAwareAnalyzer {
    private static final String ADVICE = "Consider using single device for a single map to avoid maps from competing for the disk space.";
    private final MemberConfigSupplier memberConfigs;

    MapDiskTierAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
        this.memberConfigs = pool.subscribeToConfig();
    }

    AnalysisOutcome doAnalyzeInternal(SourceDataFilter filter, IgnoreList ignoreList) {
        ArrayList problems = new ArrayList();
        filter.filter((MemberConfigMap)this.memberConfigs.get()).forEach((memberIdentifier, memberConfig) -> {
            Collection mapConfigs = memberConfig.toEffectiveConfig().getMapConfigs().values();
            problems.addAll(this.getWildcardMapProblems(memberIdentifier, mapConfigs));
            mapConfigs.stream().filter(config -> config.getTieredStoreConfig().isEnabled()).collect(Collectors.groupingBy(config -> config.getTieredStoreConfig().getDiskTierConfig().getDeviceName(), Collectors.mapping(MapConfig::getName, Collectors.toList()))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
                String deviceName = (String)entry.getKey();
                ((List)entry.getValue()).sort(String::compareTo);
                String mapNamesSeparated = String.join((CharSequence)", ", (Iterable)entry.getValue());
                problems.add(new MemberProblem(String.format("Map configs %s use device %s as a disk tier.", mapNamesSeparated, deviceName), ADVICE, Problem.ProblemType.INFO, memberIdentifier));
            });
        });
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    List<MemberProblem> getWildcardMapProblems(MemberIdentifier memberIdentifier, Collection<MapConfig> mapConfigs) {
        return mapConfigs.stream().filter(config -> config.getTieredStoreConfig().isEnabled() && config.getName().contains("*")).map(config -> new MemberProblem(String.format("Map config %s uses a wildcard in its name. This may result in multiple maps using the same device as a disk tier.", config.getName()), ADVICE, Problem.ProblemType.INFO, memberIdentifier)).toList();
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_DISK_TIER_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if a single device is configured per Tiered Storage enabled map";
    }
}

