/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.model.sql.HealthCheckIgnoreListEntry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

class IgnoreList {
    private final List<HealthCheckIgnoreListEntry> entries;

    static IgnoreList emptyIgnoreList() {
        return new IgnoreList(Collections.emptyList());
    }

    public boolean isCheckDisabled(String checkId) {
        return this.entries.stream().anyMatch(entry -> entry.getCheckId().equals(checkId) && entry.getIsDisabledClusterWide() != false);
    }

    public List<String> getDisabledDataStructures(String checkId) {
        return this.entries.stream().filter(entry -> entry.getCheckId().equals(checkId)).map(HealthCheckIgnoreListEntry::getDisabledDataStructures).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"entries"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IgnoreList(List<HealthCheckIgnoreListEntry> entries) {
        this.entries = entries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<HealthCheckIgnoreListEntry> getEntries() {
        return this.entries;
    }
}

