/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.repositories.sql.HealthCheckIgnoreListDAO;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.ConfigSemanticAnalyzerConfig;
import com.hazelcast.webmonitor.service.healthcheck.DefaultHealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.DefaultSourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.EnvironmentAnalyzerConfig;
import com.hazelcast.webmonitor.service.healthcheck.EventPublishingHealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckListener;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckMetricsCollector;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckStatusPublisher;
import com.hazelcast.webmonitor.service.healthcheck.MemberAttributeEqualityAnalyzerConfig;
import com.hazelcast.webmonitor.service.healthcheck.MemberListDataSource;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.UsageAnalyzerConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ConfigSemanticAnalyzerConfig.class, MemberAttributeEqualityAnalyzerConfig.class, EnvironmentAnalyzerConfig.class, UsageAnalyzerConfig.class, ClusterRepository.class})
public class HealthCheckConfig {
    private final MemberListDataSource memberListDataSource;
    private final MemberConfigService memberConfigService;
    private final LicenseManager licenseManager;

    @Bean
    public SourceDataSubscriptionPool sourceDataSubscriptionPool(HealthCheckMetricsCollector metricsCollector) {
        return new DefaultSourceDataSubscriptionPool(() -> ((MemberConfigService)this.memberConfigService).asMap(), this.memberListDataSource, metricsCollector);
    }

    @Bean
    HealthCheckMetricsCollector metricsCollector() {
        return new HealthCheckMetricsCollector();
    }

    @Bean
    public EventPublishingHealthCheckService eventPublishingHealthCheckService(HealthCheckService healthCheckService, List<HealthCheckListener> listeners) {
        return new EventPublishingHealthCheckService(healthCheckService, listeners);
    }

    @Bean
    HealthCheckIgnoreListDAO healthCheckIgnoreListDAO(Jdbi jdbi) {
        return new HealthCheckIgnoreListDAO(jdbi);
    }

    @Bean
    HealthCheckService healthCheckService(List<AnalysisOutcomeSource> analyzers, HealthCheckIgnoreListDAO ignoreListDAO, ClusterManager clusterManager) {
        return new DefaultHealthCheckService(analyzers, ignoreListDAO, this.licenseManager, clusterManager);
    }

    @Bean
    @ConditionalOnProperty(name={"hazelcast.mc.prometheusExporter.enabled"}, havingValue="true")
    HealthCheckStatusPublisher healthCheckStatusPublisher(HealthCheckService healthCheckService, ClusterManager clusterManager, ApplicationEventPublisher publisher) {
        return new HealthCheckStatusPublisher(healthCheckService, clusterManager, publisher);
    }

    @ConstructorProperties(value={"memberListDataSource", "memberConfigService", "licenseManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthCheckConfig(MemberListDataSource memberListDataSource, MemberConfigService memberConfigService, LicenseManager licenseManager) {
        this.memberListDataSource = memberListDataSource;
        this.memberConfigService = memberConfigService;
        this.licenseManager = licenseManager;
    }
}

