/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.DeviceConfig;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AbstractDeviceAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.PercentageUtils;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class DeviceUsageAnalyzer
extends AbstractDeviceAnalyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceUsageAnalyzer.class);
    public static final int USAGE_WARNING_THRESHOLD_PERCENTAGE = 80;
    public static final String DEVICE_USAGE_ANALYZER_DESCRIPTION = "Tiered Storage: checking if member device usage is below 80%";
    public static final String DEVICE_USAGE_ANALYZER_ADVICE = "Please set your device capacity configuration to a bigger value";

    DeviceUsageAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
    }

    String getMetricName() {
        return Metric.TIERED_STORE_DEVICE_USED_SPACE.getName();
    }

    protected Optional<MemberProblem> getMemberProblem(MemberIdentifier memberIdentifier, String deviceName, DeviceConfig deviceConfig, MetricDataPoint metricDataPoint) {
        long deviceConfigCapacity = deviceConfig.getCapacity().bytes();
        long deviceUsage = metricDataPoint.getValue();
        log.trace("Member {} device {} has capacity vs actual usage {}<>{}", new Object[]{memberIdentifier, deviceName, deviceConfigCapacity, deviceUsage});
        double usagePercentage = PercentageUtils.calculatePercentage((long)deviceUsage, (long)deviceConfigCapacity);
        if (usagePercentage > 80.0) {
            String baseDirPath = DeviceUsageAnalyzer.getDeviceBaseDirOrNull((DeviceConfig)deviceConfig);
            MemberProblem problem = DeviceUsageAnalyzer.deviceUsageMemberProblem((MemberIdentifier)memberIdentifier, (long)deviceUsage, (long)deviceConfigCapacity, (String)deviceName, (String)baseDirPath);
            log.debug(problem.getDescription());
            return Optional.of(problem);
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return "Tiered Storage: checking if member device usage is below 80%";
    }

    String getCheckId() {
        return AnalyzerCheckId.DEVICE_USAGE_ANALYZER.getCheckId();
    }

    public static MemberProblem deviceUsageMemberProblem(MemberIdentifier memberIdentifier, long deviceUsage, long deviceConfigCapacity, String deviceName, String baseDirPath) {
        double usagePercentage = PercentageUtils.calculatePercentage((long)deviceUsage, (long)deviceConfigCapacity);
        Object description = String.format("Tiered Storage: the actual device usage is %.2f%% (%,d/%,d bytes) of configured device capacity for device %s", usagePercentage, deviceUsage, deviceConfigCapacity, deviceName);
        if (baseDirPath != null) {
            description = (String)description + " at base directory " + baseDirPath;
        }
        return new MemberProblem((String)description, "Please set your device capacity configuration to a bigger value", Problem.ProblemType.WARNING, memberIdentifier);
    }
}

