/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.HealthCheckMetricsCollector;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigDataSource;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberListDataSource;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

class DefaultSourceDataSubscriptionPool
implements SourceDataSubscriptionPool {
    private final MemberConfigDataSource memberConfigDataSource;
    private final MemberListDataSource memberListDataSource;
    private final HealthCheckMetricsCollector metricsCollector;

    public MemberConfigSupplier subscribeToConfig() {
        return () -> new MemberConfigMap(this.memberConfigDataSource.asMap());
    }

    public MemberMetricsSupplier subscribeToMetric(String metricName) {
        this.metricsCollector.startCollectingMetric(metricName);
        return () -> {
            HashMap metricsMap = new HashMap(this.metricsCollector.getMemberMetric(metricName));
            List memberList = this.memberListDataSource.get();
            metricsMap.keySet().removeIf(key -> !memberList.contains(key));
            memberList.forEach(memberIdentifier -> metricsMap.putIfAbsent(memberIdentifier, null));
            return metricsMap;
        };
    }

    @ConstructorProperties(value={"memberConfigDataSource", "memberListDataSource", "metricsCollector"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultSourceDataSubscriptionPool(MemberConfigDataSource memberConfigDataSource, MemberListDataSource memberListDataSource, HealthCheckMetricsCollector metricsCollector) {
        this.memberConfigDataSource = memberConfigDataSource;
        this.memberListDataSource = memberListDataSource;
        this.metricsCollector = metricsCollector;
    }
}

