/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.webmonitor.controller.dto.healthcheck.AddIgnoreListEntryRequestDTO;
import com.hazelcast.webmonitor.model.sql.HealthCheckIgnoreListEntry;
import com.hazelcast.webmonitor.repositories.sql.HealthCheckIgnoreListDAO;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.Licensed;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.HealthcheckStatus;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

class DefaultHealthCheckService
implements HealthCheckService {
    private final List<AnalysisOutcomeSource> analyzers;
    private final HealthCheckIgnoreListDAO ignoreListDAO;
    private final LicenseManager licenseManager;
    private final ClusterManager clusterManager;
    private static final long MC_POLL_INTERVAL = 10L;
    private final Cache<String, Map<HealthcheckStatus, Long>> healthcheckCountsPerCluster = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    DefaultHealthCheckService(List<AnalysisOutcomeSource> analyzers, HealthCheckIgnoreListDAO ignoreListDAO, LicenseManager licenseManager, ClusterManager clusterManager) {
        this.analyzers = analyzers.stream().filter(Objects::nonNull).toList();
        this.ignoreListDAO = ignoreListDAO;
        this.licenseManager = licenseManager;
        this.clusterManager = clusterManager;
    }

    @Licensed
    public List<AnalysisOutcome> analyze(String cluster, boolean runFullCheck) {
        if (!this.clusterManager.isClusterConnected(cluster)) {
            return Collections.emptyList();
        }
        SourceDataFilter filter = new SourceDataFilter(cluster);
        IgnoreList ignoreList = runFullCheck ? IgnoreList.emptyIgnoreList() : new IgnoreList(this.ignoreListDAO.queryIgnoreList(cluster));
        List<AnalysisOutcome> outcomes = this.analyzers.stream().flatMap(analyzer -> analyzer.getOutcomes(filter, ignoreList)).sorted(Comparator.comparing(AnalysisOutcome::getCheckId)).collect(Collectors.toUnmodifiableList());
        if (!runFullCheck) {
            this.extractStatusCounts(cluster, outcomes);
        }
        return outcomes;
    }

    public Map<HealthcheckStatus, Long> getHealthcheckStatusCounts(String cluster) {
        Map counts = (Map)this.healthcheckCountsPerCluster.getIfPresent((Object)cluster);
        if (counts == null) {
            return this.extractStatusCounts(cluster, this.analyze(cluster, false));
        }
        return counts;
    }

    @Licensed
    public void addIgnoreListEntry(String cluster, AddIgnoreListEntryRequestDTO request) {
        this.ignoreListDAO.insertEntry(HealthCheckIgnoreListEntry.builder().checkId(request.getCheckId()).cluster(cluster).isDisabledClusterWide(request.getIsDisabledClusterWide()).disabledDataStructures(request.getDisabledDataStructures()).build());
        this.extractStatusCounts(cluster, this.analyze(cluster, false));
    }

    @Licensed
    public void resetClusterHealthcheckSettings(String cluster) {
        this.ignoreListDAO.deleteClusterEntries(cluster);
        this.extractStatusCounts(cluster, this.analyze(cluster, false));
    }

    private Map<HealthcheckStatus, Long> extractStatusCounts(String cluster, List<AnalysisOutcome> outcomes) {
        Map<HealthcheckStatus, Long> counts = outcomes.stream().flatMap(AnalysisOutcome::streamStatuses).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (HealthcheckStatus status : HealthcheckStatus.values()) {
            counts.putIfAbsent(status, 0L);
        }
        if (!this.isMCLicensed()) {
            counts.remove(HealthcheckStatus.PASS);
            counts.remove(HealthcheckStatus.DISABLED);
        }
        this.healthcheckCountsPerCluster.put((Object)cluster, counts);
        return counts;
    }

    private boolean isMCLicensed() {
        try {
            this.licenseManager.checkLicensePerFeature(Feature.MAN_CENTER);
            return true;
        }
        catch (InvalidLicenseException e) {
            return false;
        }
    }
}

