/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.config.properties.ClusterHealthCheckConfigurationProperties;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ConditionalOnCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IndexRedundancyAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapAttributeEqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapBackupCountAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapBackupReadEvictionAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapCustomAttributeAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapDiskTierAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapEvictionConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapNativeMemoryEvictionAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MapQueryCacheConsistencyAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigFileAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.NearCacheEvictionConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.PreconditionCheckingAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.TieredStorageConfigEqualityAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class ConfigSemanticAnalyzerConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigSemanticAnalyzerConfig.class);

    @Profile(value={"!hzcloud"})
    @Bean
    PreconditionCheckingAnalyzer mapAnalyzer(SourceDataSubscriptionPool pool, ClusterHealthCheckConfigurationProperties configurationProperties) {
        EnumSet healthCheckExcludes = configurationProperties.getExclude();
        try {
            return new PreconditionCheckingAnalyzer(List.of(new MapAttributeEqualityAnalyzer(pool)), List.of(new MapBackupReadEvictionAnalyzer(pool), new MapCustomAttributeAnalyzer(pool), new IndexRedundancyAnalyzer(pool), new MapNativeMemoryEvictionAnalyzer(pool), new MapQueryCacheConsistencyAnalyzer(pool), new MapEvictionConfigAnalyzer(pool), new NearCacheEvictionConfigAnalyzer(pool), new MapBackupCountAnalyzer(pool), new MapDiskTierAnalyzer(pool), new TieredStorageConfigEqualityAnalyzer(pool)), healthCheckExcludes);
        }
        catch (Exception e) {
            log.debug("Failed to create PreconditionCheckingAnalyzer", (Throwable)e);
            return null;
        }
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MAP_BACKUP_READ_EVICTION_ANALYZER)
    Analyzer backupReadEvictionAnalyzerBean(SourceDataSubscriptionPool pool) {
        return new MapBackupReadEvictionAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MAP_CUSTOM_ATTRIBUTE_ANALYZER)
    Analyzer customAttributeAnalyzerBean(SourceDataSubscriptionPool pool) {
        return new MapCustomAttributeAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.INDEX_REDUNDANCY_ANALYZER)
    Analyzer indexRedundancyAnalyzerBean(SourceDataSubscriptionPool pool) {
        return new IndexRedundancyAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MAP_NATIVE_MEMORY_EVICTION_ANALYZER)
    Analyzer nativeMemoryEvictionAnalyzerBean(SourceDataSubscriptionPool pool) {
        return new MapNativeMemoryEvictionAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MAP_QUERY_CACHE_CONSISTENCY_ANALYZER)
    Analyzer queryCacheConsistencyAnalyzerBean(SourceDataSubscriptionPool pool) {
        return new MapQueryCacheConsistencyAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MAP_EVICTION_CONFIG_ANALYZER)
    Analyzer mapEvictionConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new MapEvictionConfigAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.NEAR_CACHE_EVICTION_CONFIG_ANALYZER)
    Analyzer nearCacheEvictionConfigAnalyzer(SourceDataSubscriptionPool pool) {
        return new NearCacheEvictionConfigAnalyzer(pool);
    }

    @Profile(value={"hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MAP_BACKUP_COUNT_ANALYZER)
    Analyzer mapBackupCountAnalyzer(SourceDataSubscriptionPool pool) {
        return new MapBackupCountAnalyzer(pool);
    }

    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.MEMBER_CONFIG_FILE_ANALYZER)
    Analyzer memberConfigFileAnalyzer(MemberConfigService memberConfigService) {
        try {
            return new MemberConfigFileAnalyzer(memberConfigService);
        }
        catch (Exception e) {
            log.error("Failed to create MemberConfigFileAnalyzer", (Throwable)e);
            return null;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigSemanticAnalyzerConfig() {
    }
}

