/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.CPStatsRegistry;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.ArrayList;
import java.util.Objects;

class CPMapSoftLimitAnalyzer
extends SourceDataPoolAwareAnalyzer {
    private static final String CP_MAP_SOFT_LIMIT_ANALYZER_DESCRIPTION = "Checking if number of CPMap instances exceeded soft limit";
    static final String CP_MAP_SOFT_LIMIT_ANALYZER_PROBLEM_DESCRIPTION = "You have %d CPMap instances, we recommend a maximum of %d.";
    static final String CP_MAP_SOFT_LIMIT_ANALYZER_ADVICE = "Decrease the number of CPMap instances or configure a custom limit in member configuration.";
    private final MemberConfigSupplier memberConfigs;
    private final CPStatsRegistry cpStatsRegistry;

    CPMapSoftLimitAnalyzer(SourceDataSubscriptionPool poolDelegate, CPStatsRegistry cpStatsRegistry) {
        super(poolDelegate);
        this.memberConfigs = this.pool.subscribeToConfig();
        this.cpStatsRegistry = cpStatsRegistry;
    }

    String getCheckId() {
        return AnalyzerCheckId.CP_MAP_SOFT_LIMIT_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return CP_MAP_SOFT_LIMIT_ANALYZER_DESCRIPTION;
    }

    AnalysisOutcome doAnalyzeInternal(SourceDataFilter filter, IgnoreList ignoreList) {
        ArrayList problems = new ArrayList();
        filter.filter((MemberConfigMap)this.memberConfigs.get()).values().stream().filter(Objects::nonNull).map(MemberConfig::toEffectiveConfig).filter(memberConfig -> memberConfig.getCPSubsystemConfig().getCPMemberCount() >= 3).findAny().ifPresent(memberConfig -> {
            long limit = memberConfig.getCPSubsystemConfig().getCPMapLimit();
            int count = this.cpStatsRegistry.getKnownCPMaps(memberConfig.getClusterName()).size();
            if ((long)count > limit) {
                problems.add(new ClusterWideProblem(String.format(CP_MAP_SOFT_LIMIT_ANALYZER_PROBLEM_DESCRIPTION, count, limit), CP_MAP_SOFT_LIMIT_ANALYZER_ADVICE, Problem.ProblemType.WARNING));
            }
        });
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }
}

