/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Analyzer
implements AnalysisOutcomeSource {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);

    Analyzer() {
    }

    public final Stream<AnalysisOutcome> getOutcomes(SourceDataFilter filter, IgnoreList ignoreList) {
        return Stream.of(this.analyze(filter, ignoreList));
    }

    final AnalysisOutcome analyze() {
        return this.analyze(SourceDataFilter.noFilter(), new IgnoreList(Collections.emptyList()));
    }

    @Nonnull
    AnalysisOutcome analyze(SourceDataFilter filter, IgnoreList ignoreList) {
        if (ignoreList.isCheckDisabled(this.getCheckId())) {
            return AnalysisOutcome.disabledClusterWide((String)this.getCheckId(), (String)this.describeSelf());
        }
        try {
            return this.doAnalyze(filter, ignoreList);
        }
        catch (Exception e) {
            String analyzerClass = this.getClass().getSimpleName();
            log.error("exception occurred while running analyzer {}", (Object)analyzerClass, (Object)e);
            return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), List.of(new ClusterWideProblem(String.format("Exception thrown while running %s, please check your server logs (message: %s)", analyzerClass, e.getMessage()), "Please try again", Problem.ProblemType.WARNING)));
        }
    }

    abstract AnalysisOutcome doAnalyze(SourceDataFilter var1, IgnoreList var2);

    abstract String getCheckId();

    abstract String describeSelf();
}

