/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.diagnosticsconfig;

import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.DiagnosticsConfigResponseDTO;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.UpdateDiagnosticsConfigRequestDTO;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.diagnosticsconfig.DiagnosticsConfigManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DiagnosticsConfigVersionAwareService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsConfigVersionAwareService.class);
    public static final String DIAGNOSTICS_CONFIG_MIN_SUPPORTED_VERSION = "5.6";
    private final DiagnosticsConfigManager diagnosticsConfigManager;
    private final ClusterManager clusterManager;

    public DiagnosticsConfigResponseDTO getDiagnosticsConfig(String cluster) {
        String clusterVersion = this.clusterManager.clusterVersion(cluster);
        if (clusterVersion == null) {
            log.warn("Can't fetch cluster version for cluster '{}'. Diagnostics config is not available.", (Object)cluster);
            return null;
        }
        this.disallowForOlderVersions(cluster);
        return this.diagnosticsConfigManager.getDiagnosticsConfigurationWithDetails(cluster);
    }

    public void setDiagnosticsConfig(String cluster, UpdateDiagnosticsConfigRequestDTO updateRequest) {
        this.disallowForOlderVersions(cluster);
        this.diagnosticsConfigManager.changeDiagnosticsConfigurationState(cluster, updateRequest);
    }

    private void disallowForOlderVersions(String cluster) {
        String clusterVersion = this.clusterManager.clusterVersion(cluster);
        if (null != clusterVersion && !Version.of((String)clusterVersion).isGreaterOrEqual(Version.of((String)DIAGNOSTICS_CONFIG_MIN_SUPPORTED_VERSION))) {
            throw new OperationFailedApiException("Diagnostics config is not supported for cluster %s with version < %s".formatted(cluster, DIAGNOSTICS_CONFIG_MIN_SUPPORTED_VERSION));
        }
    }

    @ConstructorProperties(value={"diagnosticsConfigManager", "clusterManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticsConfigVersionAwareService(DiagnosticsConfigManager diagnosticsConfigManager, ClusterManager clusterManager) {
        this.diagnosticsConfigManager = diagnosticsConfigManager;
        this.clusterManager = clusterManager;
    }
}

